/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import javax.cache.CacheManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;

@Named(value="default")
public class RuntimeCacheManagerProvider
extends ComponentSupport
implements Provider<CacheManager> {
    private final Map<String, Provider<CacheManager>> providers;
    private final String name;

    @Inject
    public RuntimeCacheManagerProvider(Map<String, Provider<CacheManager>> providers, @Nullable @Named(value="${nexus.cache.provider}") @Nullable @Named(value="${nexus.cache.provider}") String customName, @Named(value="${nexus.orient.enabled:-false}") @Named(value="${nexus.orient.enabled:-false}") boolean orient, NodeAccess nodeAccess) {
        this.providers = (Map)Preconditions.checkNotNull(providers);
        this.name = customName != null ? customName : this.getCustomName(orient, nodeAccess);
        Preconditions.checkArgument((!"default".equals(this.name) ? 1 : 0) != 0);
        this.log.info("Cache-provider: {}", (Object)this.name);
        Preconditions.checkState((boolean)providers.containsKey(this.name), (String)"Missing cache-provider: %s", (Object)this.name);
    }

    private String getCustomName(@Named(value="nexus.orient.enabled") @Named(value="nexus.orient.enabled") boolean orient, NodeAccess nodeAccess) {
        return orient && nodeAccess.isClustered() ? "hazelcast" : "ehcache";
    }

    public CacheManager get() {
        Provider<CacheManager> provider = this.providers.get(this.name);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (String)"Cache-provider vanished: %s", (Object)this.name);
        CacheManager manager = (CacheManager)provider.get();
        this.log.debug("Constructed cache-provider: {} -> {}", (Object)this.name, (Object)manager);
        return manager;
    }
}

