/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal;

import com.google.common.base.Preconditions;
import javax.cache.configuration.Factory;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;
import org.sonatype.nexus.cache.internal.LocalCache;

@Named
@Singleton
public class LocalCacheManager<K, V>
implements CacheManager<K, V> {
    private final CacheHelper cacheHelper;

    @Inject
    public LocalCacheManager(CacheHelper cacheHelper) {
        this.cacheHelper = (CacheHelper)((Object)Preconditions.checkNotNull((Object)((Object)cacheHelper)));
    }

    @Override
    public NexusCache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType, Duration expiryAfter) {
        return new LocalCache<K, V>(this.cacheHelper.maybeCreateCache(cacheName, keyType, valueType, (Factory<? extends ExpiryPolicy>)CreatedExpiryPolicy.factoryOf((Duration)expiryAfter)));
    }

    @Override
    public void destroyCache(String cacheName) {
        this.cacheHelper.maybeDestroyCache(cacheName);
    }
}

