/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.systemchecks.NodeSystemCheckResult;
import org.sonatype.nexus.systemchecks.SystemCheckService;

@Named
@Singleton
public class HealthCheckStateContributor
extends ComponentSupport
implements StateContributor {
    @VisibleForTesting
    protected static final String HC_FAILED_KEY = "health_checks_failed";
    private SystemCheckService systemCheckService;

    @Inject
    public HealthCheckStateContributor(SystemCheckService systemCheckService) {
        this.systemCheckService = (SystemCheckService)Preconditions.checkNotNull((Object)systemCheckService);
    }

    @Override
    @Nullable
    public Map<String, Object> getState() {
        boolean failed = this.systemCheckService.getResults().map(NodeSystemCheckResult::getResult).map(Map::values).flatMap(Collection::stream).anyMatch(result -> !result.isHealthy());
        return ImmutableMap.of((Object)HC_FAILED_KEY, (Object)failed);
    }
}

