/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.security;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.security.authc.LoginEvent;
import org.sonatype.nexus.security.authc.LogoutEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.session.enabled")
public class SessionServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SessionServlet.class);
    private final EventManager eventManager;

    @Inject
    public SessionServlet(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject subject = SecurityUtils.getSubject();
        log.info("Created session for user: {}", subject.getPrincipal());
        Optional realmName = subject.getPrincipals().getRealmNames().stream().findFirst();
        realmName.ifPresent(realm -> this.eventManager.post((Object)new LoginEvent(subject.getPrincipal().toString(), realm)));
        Preconditions.checkState((boolean)subject.isAuthenticated());
        Preconditions.checkState((subject.getSession(false) != null ? 1 : 0) != 0);
        response.setStatus(204);
        response.setHeader("X-Frame-Options", "DENY");
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject subject = SecurityUtils.getSubject();
        log.info("Deleting session for user: {}", subject.getPrincipal());
        Optional realmName = subject.getPrincipals().getRealmNames().stream().findFirst();
        realmName.ifPresent(realm -> this.eventManager.post((Object)new LogoutEvent(subject.getPrincipal().toString(), realm)));
        subject.logout();
        Preconditions.checkState((!subject.isAuthenticated() ? 1 : 0) != 0);
        Preconditions.checkState((!subject.isRemembered() ? 1 : 0) != 0);
        Preconditions.checkState((subject.getSession(false) == null ? 1 : 0) != 0);
        response.setStatus(204);
        response.setHeader("X-Frame-Options", "DENY");
    }
}

