/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.security;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotEmpty;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.rapture.internal.security.PermissionXO;
import org.sonatype.nexus.rapture.internal.security.UserXO;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;
import org.sonatype.nexus.security.anonymous.AnonymousManager;
import org.sonatype.nexus.security.authz.WildcardPermission2;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"rapture_Security"})
public class SecurityComponent
extends DirectComponentSupport
implements StateContributor {
    private final SecuritySystem securitySystem;
    private final AnonymousManager anonymousManager;
    private final AuthTicketService authTickets;

    @Inject
    public SecurityComponent(SecuritySystem securitySystem, AnonymousManager anonymousManager, AuthTicketService authTickets) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.anonymousManager = (AnonymousManager)Preconditions.checkNotNull((Object)anonymousManager);
        this.authTickets = (AuthTicketService)Preconditions.checkNotNull((Object)authTickets);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    public UserXO authenticate(@NotEmpty String base64Username, @NotEmpty String base64Password) throws Exception {
        Subject subject = this.securitySystem.getSubject();
        Preconditions.checkState((subject != null ? 1 : 0) != 0);
        try {
            subject.login((AuthenticationToken)new UsernamePasswordToken(Strings2.decodeBase64((String)base64Username), Strings2.decodeBase64((String)base64Password), false));
        }
        catch (Exception e) {
            throw new Exception("Authentication failed", e);
        }
        return this.getUser();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    public String authenticationToken(@NotEmpty String base64Username, @NotEmpty String base64Password) throws Exception {
        Subject subject = this.securitySystem.getSubject();
        if (subject == null || !subject.isAuthenticated()) {
            this.authenticate(base64Username, base64Password);
        }
        String username = Strings2.decodeBase64((String)base64Username);
        String password = Strings2.decodeBase64((String)base64Password);
        this.log.debug("Authenticate w/username: {}, password: {}", (Object)username, (Object)Strings2.mask((String)password));
        subject = this.securitySystem.getSubject();
        if (!subject.getPrincipal().toString().equals(username)) {
            throw new Exception("Username mismatch");
        }
        try {
            SecurityUtils.getSecurityManager().authenticate((AuthenticationToken)new UsernamePasswordToken(username, password));
        }
        catch (AuthenticationException e) {
            throw new Exception("Authentication failed", e);
        }
        Optional realmName = subject.getPrincipals().getRealmNames().stream().findFirst();
        return this.authTickets.createTicket(username, (String)realmName.orElse(null));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public UserXO getUser() {
        UserXO userXO = null;
        Subject subject = this.securitySystem.getSubject();
        if (subject != null && subject.isAuthenticated()) {
            Object principal;
            userXO = new UserXO();
            userXO.setAuthenticated(subject.isAuthenticated());
            userXO.setAuthenticatedRealms(subject.getPrincipals().getRealmNames());
            if (subject.isPermitted((Permission)new WildcardPermission2("nexus:*"))) {
                userXO.setAdministrator(true);
            }
            if ((principal = subject.getPrincipal()) != null) {
                userXO.setId(principal.toString());
            }
        }
        return userXO;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public List<PermissionXO> getPermissions() {
        List<PermissionXO> permissions = null;
        Subject subject = this.securitySystem.getSubject();
        if (subject != null && (subject.isAuthenticated() || subject.isRemembered())) {
            permissions = this.calculatePermissions(subject);
        }
        return permissions;
    }

    @Override
    public Map<String, Object> getState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("user", this.getUser());
        AnonymousConfiguration anonymousConfiguration = this.anonymousManager.getConfiguration();
        state.put("anonymousUsername", anonymousConfiguration.isEnabled() ? anonymousConfiguration.getUserId() : null);
        return state;
    }

    private List<PermissionXO> calculatePermissions(Subject subject) {
        this.log.debug("Calculating permissions");
        ArrayList<Permission> granted = new ArrayList<Permission>();
        ArrayList<PermissionXO> result = new ArrayList<PermissionXO>();
        for (Privilege privilege : this.securitySystem.listPrivileges()) {
            if (!(privilege.getPermission() instanceof WildcardPermission2)) continue;
            granted.add(privilege.getPermission());
        }
        boolean[] boolResults = subject.isPermitted(granted);
        int i = 0;
        while (i < granted.size()) {
            if (boolResults[i]) {
                PermissionXO entry = new PermissionXO();
                entry.setId(((Permission)granted.get(i)).toString());
                result.add(entry);
            }
            ++i;
        }
        return result;
    }
}

