/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.branding;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.rapture.internal.branding.Branding;
import org.sonatype.nexus.rapture.internal.branding.BrandingCapabilityConfiguration;

@Named(value="rapture.branding")
public class BrandingCapability
extends CapabilitySupport<BrandingCapabilityConfiguration> {
    private final Branding branding;

    @Inject
    public BrandingCapability(Branding branding) {
        this.branding = (Branding)Preconditions.checkNotNull((Object)branding);
    }

    protected BrandingCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new BrandingCapabilityConfiguration(properties);
    }

    protected void onActivate(BrandingCapabilityConfiguration config) throws Exception {
        this.branding.set(config);
    }

    protected void onPassivate(BrandingCapabilityConfiguration config) throws Exception {
        this.branding.reset();
    }

    protected void onRemove(BrandingCapabilityConfiguration config) throws Exception {
        this.branding.reset();
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }
}

