/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.template.TemplateAccessible;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.rapture.UiPluginDescriptor;
import org.sonatype.nexus.rapture.internal.state.StateComponent;
import org.sonatype.nexus.servlet.ServletHelper;
import org.sonatype.nexus.webresources.GeneratedWebResource;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceBundle;

@Named
@Singleton
public class RaptureWebResourceBundle
extends ComponentSupport
implements WebResourceBundle {
    public static final String PRO_STARTER = "PRO-STARTER";
    private final ApplicationVersion applicationVersion;
    private final Provider<HttpServletRequest> servletRequestProvider;
    private final Provider<StateComponent> stateComponentProvider;
    private final TemplateHelper templateHelper;
    private final List<org.sonatype.nexus.ui.UiPluginDescriptor> pluginDescriptors;
    private final List<UiPluginDescriptor> extJsPluginDescriptors;
    private final Gson gson;
    private final String cacheBuster;
    private final boolean analyticsEnabled;
    public static final String PROPERTY_WEBRESOURCES_CACHEBUSTER = "nexus.webresources.cachebuster";

    @Inject
    public RaptureWebResourceBundle(ApplicationVersion applicationVersion, Provider<HttpServletRequest> servletRequestProvider, Provider<StateComponent> stateComponentProvider, TemplateHelper templateHelper, List<org.sonatype.nexus.ui.UiPluginDescriptor> pluginDescriptors, List<UiPluginDescriptor> extJsPluginDescriptors, @Nullable @Named(value="${nexus.webresources.cachebuster}") @Nullable @Named(value="${nexus.webresources.cachebuster}") String cacheBuster, @Named(value="${nexus.analytics.enabled:-true}") @Named(value="${nexus.analytics.enabled:-true}") boolean analyticsEnabled) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.servletRequestProvider = (Provider)Preconditions.checkNotNull(servletRequestProvider);
        this.stateComponentProvider = (Provider)Preconditions.checkNotNull(stateComponentProvider);
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        this.pluginDescriptors = (List)Preconditions.checkNotNull(pluginDescriptors);
        this.extJsPluginDescriptors = (List)Preconditions.checkNotNull(extJsPluginDescriptors);
        this.analyticsEnabled = analyticsEnabled;
        if (cacheBuster == null) {
            this.cacheBuster = applicationVersion.getBuildTimestamp();
        } else {
            this.log.info("Setting web resources cache buster value to {} from property {}", (Object)cacheBuster, (Object)PROPERTY_WEBRESOURCES_CACHEBUSTER);
            this.cacheBuster = cacheBuster;
        }
        this.log.info("UI plugin descriptors:");
        for (org.sonatype.nexus.ui.UiPluginDescriptor uiPluginDescriptor : pluginDescriptors) {
            this.log.info("  {}", (Object)uiPluginDescriptor.getName());
        }
        this.log.info("ExtJS UI plugin descriptors:");
        for (UiPluginDescriptor uiPluginDescriptor : extJsPluginDescriptors) {
            this.log.info("  {}", (Object)uiPluginDescriptor.getPluginId());
        }
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public List<WebResource> getResources() {
        return ImmutableList.of((Object)this.index_html(), (Object)this.bootstrap_js(), (Object)this.baseapp_css(), (Object)this.app_js(), (Object)this.copyright_html());
    }

    private WebResource index_html() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/index.html";
            }

            public String getContentType() {
                return "text/html";
            }

            protected byte[] generate() throws IOException {
                return this.render("index.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.get()).set("relativePath", (Object)BaseUrlHolder.getRelativePath()).set("debug", (Object)this.isDebug()).set("urlSuffix", (Object)this.generateUrlSuffix()).set("styles", this.getStyles()).set("scripts", this.getScripts()).set("util", (Object)new TemplateUtil()).set("analyticsEnabled", (Object)(applicationVersion.getEdition().equals(RaptureWebResourceBundle.PRO_STARTER) || analyticsEnabled ? 1 : 0)));
            }
        };
    }

    private WebResource bootstrap_js() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/static/rapture/bootstrap.js";
            }

            public String getContentType() {
                return "application/x-javascript";
            }

            protected byte[] generate() throws IOException {
                return this.render("bootstrap.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.get()).set("relativePath", (Object)BaseUrlHolder.getRelativePath()).set("debug", (Object)this.isDebug()).set("urlSuffix", (Object)this.generateUrlSuffix()).set("namespaces", this.getExtJsNamespaces()));
            }
        };
    }

    private WebResource baseapp_css() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/static/rapture/resources/baseapp.css";
            }

            public String getContentType() {
                return "text/css";
            }

            protected byte[] generate() throws IOException {
                return this.render("baseapp_css.vm", new TemplateParameters().set("debug", (Object)this.isDebug()).set("urlSuffix", (Object)this.generateUrlSuffix()));
            }
        };
    }

    private WebResource copyright_html() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/COPYRIGHT.html";
            }

            public String getContentType() {
                return "text/html";
            }

            protected byte[] generate() throws IOException {
                String edition = "OSS".equals(applicationVersion.getEdition()) ? "oss" : "pro";
                return this.render("COPYRIGHT.vm", new TemplateParameters().set("edition", (Object)edition));
            }
        };
    }

    private WebResource app_js() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/static/rapture/app.js";
            }

            public String getContentType() {
                return "application/x-javascript";
            }

            protected byte[] generate() throws IOException {
                return this.render("app.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.getRelativePath()).set("debug", (Object)this.isDebug()).set("state", (Object)gson.toJson((Object)this.getState())).set("pluginConfigs", this.getExtJsPluginConfigs()));
            }
        };
    }

    private String generateUrlSuffix() {
        StringBuilder buff = new StringBuilder();
        String version = this.applicationVersion.getVersion();
        String edition = this.applicationVersion.getEdition();
        buff.append("_v=").append(version);
        buff.append("&_e=").append(edition);
        buff.append("&_c=").append(this.cacheBuster);
        if (version.endsWith("SNAPSHOT")) {
            buff.append("&_dc=").append(System.currentTimeMillis());
        }
        if (this.isDebug()) {
            buff.append("&debug=true");
        }
        return buff.toString();
    }

    private boolean isDebug() {
        HttpServletRequest request = (HttpServletRequest)this.servletRequestProvider.get();
        return ServletHelper.isDebug((HttpServletRequest)request);
    }

    private Map<String, Object> getState() {
        return ((StateComponent)((Object)this.stateComponentProvider.get())).getState(Maps.newHashMap());
    }

    @VisibleForTesting
    List<String> getExtJsPluginConfigs() {
        ArrayList classNames = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.extJsPluginDescriptors) {
            String className = descriptor.getConfigClassName();
            if (className == null) continue;
            classNames.add(className);
        }
        return classNames;
    }

    @VisibleForTesting
    List<String> getExtJsNamespaces() {
        ArrayList namespaces = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.extJsPluginDescriptors) {
            String ns = descriptor.getNamespace();
            if (ns == null) continue;
            namespaces.add(ns);
        }
        return namespaces;
    }

    private String mode(String path) {
        String mode = this.isDebug() ? "debug" : "prod";
        return path.replaceAll("\\{mode\\}", mode);
    }

    private URI uri(String path) {
        try {
            return new URI(String.format("%s/static/rapture/%s", BaseUrlHolder.getRelativePath(), path));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI relativeToAbsoluteUri(String path) {
        try {
            return new URI(String.format("%s%s", BaseUrlHolder.getRelativePath(), path));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    List<URI> getStyles() {
        ArrayList styles = Lists.newArrayList();
        styles.add(this.uri(this.mode("resources/loading-{mode}.css")));
        styles.add(this.uri(this.mode("resources/baseapp.css")));
        styles.addAll(this.getExtJsStyles());
        List resources = this.pluginDescriptors.stream().map(org.sonatype.nexus.ui.UiPluginDescriptor::getStyles).flatMap(Collection::stream).map(this::relativeToAbsoluteUri).collect(Collectors.toList());
        styles.addAll(resources);
        return styles;
    }

    private List<URI> getExtJsStyles() {
        ArrayList styles = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.extJsPluginDescriptors) {
            if (!descriptor.hasStyle()) continue;
            String path = String.format("resources/%s-{mode}.css", descriptor.getPluginId());
            styles.add(this.uri(this.mode(path)));
        }
        return styles;
    }

    @VisibleForTesting
    List<URI> getScripts() {
        boolean debug = this.isDebug();
        ArrayList scripts = Lists.newArrayList();
        scripts.add(this.uri(this.mode("baseapp-{mode}.js")));
        scripts.add(this.uri(this.mode("extdirect-{mode}.js")));
        scripts.add(this.uri("bootstrap.js"));
        scripts.addAll(this.extJsPluginDescriptors.stream().map(descriptor -> descriptor.getScripts(debug)).flatMap(Collection::stream).map(this::relativeToAbsoluteUri).collect(Collectors.toList()));
        List resources = this.pluginDescriptors.stream().map(descriptor -> descriptor.getScripts(debug)).flatMap(Collection::stream).map(this::relativeToAbsoluteUri).collect(Collectors.toList());
        scripts.addAll(resources);
        if (!debug) {
            scripts.addAll(this.getExtJsScripts());
        }
        scripts.add(this.uri("app.js"));
        return scripts;
    }

    private List<URI> getExtJsScripts() {
        ArrayList scripts = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.extJsPluginDescriptors) {
            if (!descriptor.hasScript()) continue;
            String path = String.format("%s-prod.js", descriptor.getPluginId());
            scripts.add(this.uri(path));
        }
        return scripts;
    }

    @TemplateAccessible
    public static class TemplateUtil {
        public String fileName(URI uri) {
            String path = uri.getPath();
            int i = path.lastIndexOf(47);
            return path.substring(i + 1, path.length());
        }
    }

    private abstract class TemplateWebResource
    extends GeneratedWebResource {
        private TemplateWebResource() {
        }

        protected byte[] render(String template, TemplateParameters parameters) throws IOException {
            this.log.trace("Rendering template: {}, with params: {}", (Object)template, (Object)parameters);
            URL url = ((Object)((Object)this)).getClass().getResource(template);
            return RaptureWebResourceBundle.this.templateHelper.render(url, parameters).getBytes();
        }
    }
}

