/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.webresources.UrlWebResource;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceBundle;

@Named
@Singleton
public class PublicFilesWebResourceBundle
extends ComponentSupport
implements WebResourceBundle {
    private static final List<String> FILES = Arrays.asList("apple-touch-icon.png", "browserconfig.xml", "favicon.ico", "favicon-16x16.png", "favicon-32x32.png", "mstile-144x144.png", "mstile-150x150.png", "mstile-310x310.png", "mstile-70x70.png", "OSS-LICENSE.html", "PRO-LICENSE.html", "robots.txt", "safari-pinned-tab.svg");
    private final MimeSupport mimeSupport;

    @Inject
    public PublicFilesWebResourceBundle(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    public List<WebResource> getResources() {
        return FILES.stream().map(this::toWebResource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private WebResource toWebResource(String filename) {
        URL url = PublicFilesWebResourceBundle.class.getResource("/static/public/" + filename);
        if (url == null) {
            return null;
        }
        return new UrlWebResource(url, String.valueOf('/') + filename, this.getContentType(filename));
    }

    private String getContentType(String filename) {
        return this.mimeSupport.guessMimeTypeFromPath(filename, new MimeRulesSource[0]);
    }
}

