/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.systemchecks.NodeSystemCheckResult;
import org.sonatype.nexus.systemchecks.SystemCheckService;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class LocalSystemCheckService
extends StateGuardLifecycleSupport
implements SystemCheckService {
    private final PeriodicJobService jobService;
    private final NodeAccess nodeAccess;
    private String hostname;
    private LoadingCache<String, HealthCheck.Result> cache;
    private HealthCheckRegistry registry;
    private int refreshInterval;
    private PeriodicJobService.PeriodicJob metricsWritingJob;

    @Inject
    public LocalSystemCheckService(PeriodicJobService jobService, HealthCheckRegistry registry, NodeAccess nodeAccess, @Named(value="${nexus.healthcheck.refreshInterval:-15}") @Named(value="${nexus.healthcheck.refreshInterval:-15}") int refreshInterval) {
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
        this.registry = (HealthCheckRegistry)Preconditions.checkNotNull((Object)registry);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.refreshInterval = refreshInterval;
    }

    protected void doStart() throws Exception {
        this.cache = CacheBuilder.newBuilder().build(this.cacheLoader());
        this.jobService.startUsing();
        this.nodeAccess.getHostName().thenAccept(value -> {
            String string = this.hostname = value;
        }).exceptionally(ex -> {
            this.hostname = this.nodeAccess.getId();
            return null;
        });
        this.metricsWritingJob = this.jobService.schedule(() -> this.registry.getNames().forEach(k -> {
            HealthCheck.Result oldResult = (HealthCheck.Result)this.cache.getUnchecked(k);
            this.cache.refresh(k);
            HealthCheck.Result newResult = (HealthCheck.Result)this.cache.getUnchecked(k);
            if (oldResult.isHealthy() != newResult.isHealthy()) {
                this.log.info("Health check status changed from {} to {} for {}", new Object[]{oldResult.isHealthy(), newResult.isHealthy(), k});
            }
        }), this.refreshInterval);
    }

    protected void doStop() throws Exception {
        this.metricsWritingJob.cancel();
        this.metricsWritingJob = null;
        this.jobService.stopUsing();
        this.cache = null;
    }

    private CacheLoader<String, HealthCheck.Result> cacheLoader() {
        return new CacheLoader<String, HealthCheck.Result>(){

            public HealthCheck.Result load(String s) {
                return LocalSystemCheckService.this.registry.runHealthCheck(s);
            }
        };
    }

    @Guarded(by={"STARTED"})
    public Stream<NodeSystemCheckResult> getResults() {
        return Collections.singleton(new NodeSystemCheckResult(this.nodeAccess.getId(), this.hostname, (Map)this.cache.asMap())).stream();
    }
}

