/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.service.TagCleanupService;
import com.sonatype.nexus.tags.tasks.TagCleanupTaskConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class TagCleanupTask
extends TaskSupport
implements Cancelable {
    private final TagCleanupService tagCleanupService;

    @Inject
    public TagCleanupTask(TagCleanupService tagCleanupService) {
        this.tagCleanupService = (TagCleanupService)Preconditions.checkNotNull((Object)tagCleanupService);
    }

    protected Void execute() {
        TagCleanupTaskConfiguration configuration = this.getTagCleanupTaskConfiguration();
        if (!configuration.validate()) {
            return null;
        }
        this.tagCleanupService.cleanup(configuration);
        return null;
    }

    public String getMessage() {
        return "Cleanup tags based on specified criteria";
    }

    @VisibleForTesting
    protected TagCleanupTaskConfiguration getTagCleanupTaskConfiguration() {
        return new TagCleanupTaskConfiguration(this.getConfiguration());
    }
}

