/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.search.orient;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.elasticsearch.OrientSearchExtension;

@Named
@Singleton
public class TagOrientSearchExtension
implements OrientSearchExtension {
    public void updateComponent(ComponentSearchResult component, SearchHit hit) {
        List tags = this.getTags(hit);
        if (tags != null) {
            component.addAnnotation("tags", (Object)tags);
        }
    }

    private List getTags(SearchHit hit) {
        Map source = (Map)Preconditions.checkNotNull((Object)hit.getSource());
        Object obj = source.get("tags");
        return obj instanceof List ? (List)obj : null;
    }
}

