/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.search;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;

public abstract class TagSearchExtensionSupport
extends ComponentSupport {
    protected final ComponentTagStoreManager componentTagStoreManager;
    protected final TagStore tagStore;

    public TagSearchExtensionSupport(ComponentTagStoreManager componentTagStoreManager, TagStore tagStore) {
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
    }

    protected List<String> getTags(FluentComponent component) {
        BiFunction<Integer, String, Continuation> browseFunction = (limit, token) -> this.componentTagStoreManager.getStoreForRepository(component.repository()).browseComponentTags((Component)component, (int)limit, (String)token);
        Set<Integer> tagIds = Continuations.streamOf(browseFunction).map(ComponentTag::getTagId).collect(Collectors.toSet());
        return this.tagStore.getByIds(tagIds).stream().map(Tag::name).collect(Collectors.toList());
    }
}

