/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.tags.orient.OrientTag;
import com.sonatype.nexus.tags.orient.TagCreatedEvent;
import com.sonatype.nexus.tags.orient.TagDeletedEvent;
import com.sonatype.nexus.tags.orient.TagUpdatedEvent;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.ReadEntitiesByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;

@Named
@Singleton
public class TagEntityAdapter
extends IterableEntityAdapter<OrientTag> {
    public static final String P_TAG_NAME = "name";
    public static final String P_FIRST_CREATED = "first_created";
    public static final String P_LAST_UPDATED = "last_updated";
    public static final String DB_CLASS = new OClassNameBuilder().type("tag").build();
    public static final String I_TAG_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final ReadEntityByPropertyAction<OrientTag> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final ReadEntitiesByPropertyAction<OrientTag> readEntities = new ReadEntitiesByPropertyAction((EntityAdapter)this, "name");

    @Inject
    public TagEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_TAG_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty("attributes", OType.EMBEDDEDMAP).setNotNull(true);
        type.createProperty(P_FIRST_CREATED, OType.DATETIME).setReadonly(true).setMandatory(true).setNotNull(true);
        type.createProperty(P_LAST_UPDATED, OType.DATETIME).setMandatory(true).setNotNull(true);
        type.createIndex(I_TAG_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_TAG_NAME});
    }

    public OrientTag newEntity() {
        return new OrientTag();
    }

    public void readFields(ODocument document, OrientTag entity) {
        String name = (String)document.field(P_TAG_NAME, OType.STRING);
        Map attributes = (Map)document.field("attributes", OType.EMBEDDEDMAP);
        Date firstCreated = (Date)document.field(P_FIRST_CREATED, OType.DATETIME);
        Date lastUpdated = (Date)document.field(P_LAST_UPDATED, OType.DATETIME);
        entity.name(name);
        entity.attributes(new NestedAttributesMap("attributes", attributes));
        entity.firstCreated(new DateTime((Object)firstCreated));
        entity.lastUpdated(new DateTime((Object)lastUpdated));
    }

    protected void writeFields(ODocument document, OrientTag entity) {
        document.field(P_TAG_NAME, (Object)entity.name());
        document.field("attributes", (Object)entity.attributes().backing());
        Date firstCreated = document.getIdentity().isNew() ? new Date() : (Date)Preconditions.checkNotNull((Object)((Date)document.field(P_FIRST_CREATED, OType.DATETIME)));
        document.field(P_FIRST_CREATED, (Object)firstCreated);
        document.field(P_LAST_UPDATED, (Object)new Date());
        entity.firstCreated(new DateTime((Object)firstCreated));
        entity.lastUpdated(new DateTime((Object)new Date()));
    }

    @Nullable
    public OrientTag read(ODatabaseDocumentTx db, String name) {
        return (OrientTag)this.read.execute(db, new Object[]{name});
    }

    public List<OrientTag> read(ODatabaseDocumentTx db, Set<String> names) {
        return this.readEntities.execute(db, names);
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String name = (String)document.field(P_TAG_NAME);
        this.log.debug("newEvent: eventKind: {}, tag name: {}, metadata: {}", new Object[]{eventKind, name, metadata});
        switch (eventKind) {
            case CREATE: {
                return new TagCreatedEvent((EntityMetadata)metadata, name);
            }
            case UPDATE: {
                return new TagUpdatedEvent((EntityMetadata)metadata, name);
            }
            case DELETE: {
                return new TagDeletedEvent((EntityMetadata)metadata, name);
            }
        }
        return null;
    }
}

