/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class OrientTag
extends AbstractEntity
implements Tag {
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @Size(min=1, max=256)
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @Size(min=1, max=256) String name;
    private NestedAttributesMap attributes;
    private DateTime firstCreated;
    private DateTime lastUpdated;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public OrientTag name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public NestedAttributesMap attributes() {
        Preconditions.checkState((this.attributes != null ? 1 : 0) != 0, (String)"Missing attributes: %s", (Object)"attributes");
        return this.attributes;
    }

    @Override
    public OrientTag attributes(NestedAttributesMap attributes) {
        this.attributes = (NestedAttributesMap)Preconditions.checkNotNull((Object)attributes);
        return this;
    }

    @Override
    public DateTime firstCreated() {
        return this.firstCreated;
    }

    public OrientTag firstCreated(DateTime firstCreated) {
        this.firstCreated = (DateTime)Preconditions.checkNotNull((Object)firstCreated);
        return this;
    }

    @Override
    public DateTime lastUpdated() {
        return this.lastUpdated;
    }

    public OrientTag lastUpdated(DateTime lastUpdated) {
        this.lastUpdated = (DateTime)Preconditions.checkNotNull((Object)lastUpdated);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return this.name.equals(tag.name());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

