/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class TagsSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String TAG_DOMAIN = "tags";
    public static final String TAG_PRIV_ID_PREFIX = "nx-tags";
    public static final String TAG_ASSOCIATE_PRIV_ID = "nx-tags-associate";
    public static final String TAG_ASSOCIATE_PRIV_DESCRIPTION = "Associate permission for Tags";
    public static final String TAG_DISASSOCIATE_PRIV_ID = "nx-tags-disassociate";
    public static final String TAG_DISASSOCIATE_PRIV_DESCRIPTION = "Disassociate permission for Tags";
    public static final String ACTION_ASSOCIATE = "associate,read";
    public static final String ACTION_DISASSOCIATE = "disassociate,read";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        this.createCrudAndAllApplicationPrivileges(TAG_PRIV_ID_PREFIX, TAG_DOMAIN).forEach(arg_0 -> ((MemorySecurityConfiguration)config).addPrivilege(arg_0));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(TAG_ASSOCIATE_PRIV_ID, TAG_ASSOCIATE_PRIV_DESCRIPTION, TAG_DOMAIN, ACTION_ASSOCIATE));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(TAG_DISASSOCIATE_PRIV_ID, TAG_DISASSOCIATE_PRIV_DESCRIPTION, TAG_DOMAIN, ACTION_DISASSOCIATE));
        return config;
    }
}

