/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import com.sonatype.nexus.tags.datastore.TagData;
import com.sonatype.nexus.tags.service.ComponentsNotFoundException;
import com.sonatype.nexus.tags.service.TagAlreadyExistsException;
import com.sonatype.nexus.tags.service.TagAttributesTooLargeException;
import com.sonatype.nexus.tags.service.TagNotFoundException;
import com.sonatype.nexus.tags.service.TagService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.search.SearchEventHandler;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.search.ComponentSearchResult;

@Named
@Singleton
public class TagServiceImpl
extends StateGuardLifecycleSupport
implements TagService {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String GROUP = "group";
    private static final String SORT_PROPERTY = "id";
    private static final String SORT_DIRECTION = "asc";
    private static final int BROWSE_LIMIT = 10;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final TagStore tagStore;
    private final ObjectMapper objectMapper;
    private final RepositoryManager repositoryManager;
    private final int maxJsonAttributesSize;
    private final SearchEventHandler searchEventHandler;

    @Inject
    public TagServiceImpl(ComponentTagStoreManager componentTagStoreManager, TagStore tagStore, ObjectMapper objectMapper, RepositoryManager repositoryManager, SearchEventHandler searchEventHandler, @Named(value="${nexus.tags.maxAttributesSize:-20000}") @Named(value="${nexus.tags.maxAttributesSize:-20000}") int maxJsonAttributesSize) {
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.searchEventHandler = (SearchEventHandler)Preconditions.checkNotNull((Object)searchEventHandler);
        this.maxJsonAttributesSize = maxJsonAttributesSize;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Iterable<Tag> list() {
        return this.tagStore.list();
    }

    @Override
    @Guarded(by={"STARTED"})
    public PageResult<Tag> browse(String continuationToken) {
        if (!this.isValidContinuationToken(continuationToken).booleanValue()) {
            throw new TagNotFoundException(String.format("Invalid token '%s'", continuationToken));
        }
        QueryOptions queryOptions = new QueryOptions(null, SORT_PROPERTY, SORT_DIRECTION, Integer.valueOf(0), Integer.valueOf(10), continuationToken, false);
        List<Tag> tags = this.tagStore.browse(queryOptions);
        return new PageResult(queryOptions, tags);
    }

    @Override
    @Guarded(by={"STARTED"})
    public String getContinuationToken(PageResult<Tag> page) {
        return this.tagStore.getContinuationToken(page.getResults());
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Tag get(String name) {
        return this.tagStore.get(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Tag> get(Set<String> names) {
        return this.tagStore.get(names);
    }

    @Override
    @Guarded(by={"STARTED"})
    @NotNull
    public Tag require(String name) {
        return this.getOrThrowNotFound(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Tag create(String name, @Nullable Map<String, Object> attributes) {
        this.checkExists(name);
        this.checkAttributesSize(attributes);
        Tag tag = new TagData().name(name).attributes(new NestedAttributesMap("attributes", attributes == null ? Collections.emptyMap() : attributes));
        this.tagStore.create(tag);
        return this.tagStore.get(tag.name());
    }

    @Override
    @Guarded(by={"STARTED"})
    public Tag update(String name, Map<String, Object> attributes) {
        Tag tag = this.getOrThrowNotFound(name);
        this.checkAttributesSize(attributes);
        tag.attributes(new NestedAttributesMap("attributes", attributes));
        this.tagStore.update(tag);
        return this.tagStore.get(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(String name) {
        Tag tag = this.getOrThrowNotFound(name);
        Map taggedByRepository = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).collect(Collectors.toMap(Function.identity(), repository -> {
            Integer contentRepositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
            return this.componentTagStoreManager.getStoreForRepository((Repository)repository).findTaggedComponentIds(tag, contentRepositoryId);
        }));
        this.tagStore.delete(tag);
        taggedByRepository.entrySet().stream().filter(e -> !((Collection)e.getValue()).isEmpty()).forEach(entry -> {
            Repository repository = (Repository)entry.getKey();
            String format = repository.getFormat().getValue();
            ((Collection)entry.getValue()).forEach(componentId -> this.searchEventHandler.requestIndex(format, componentId.intValue(), repository));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> associate(String tagName, Iterable<ComponentSearchResult> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new ComponentsNotFoundException();
        }
        return this.associate(this.getOrThrowNotFound(tagName), searchHits);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> associateById(String tagName, Repository repository, EntityId componentId) {
        return this.associateById(this.getOrThrowNotFound(tagName), repository, componentId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> maybeAssociateById(String tagName, Repository repository, EntityId componentId) {
        return this.maybeAssociateById(this.getOrThrowNotFound(tagName), repository, componentId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociate(String tagName, Iterable<ComponentSearchResult> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new ComponentsNotFoundException();
        }
        return this.disassociate(this.getOrThrowNotFound(tagName), searchHits);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociateById(String tagName, Repository repository, EntityId componentId) {
        return this.disassociateById(this.getOrThrowNotFound(tagName), repository, componentId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociateById(Tag tag, Repository repository, EntityId componentId) {
        ArrayList<Map<String, String>> disassociated = new ArrayList<Map<String, String>>();
        Component component = (Component)((ContentFacet)repository.facet(ContentFacet.class)).components().find(componentId).orElseThrow(ComponentsNotFoundException::new);
        this.log.debug("Disassociating component '{}' from tag '{}'", (Object)component.name(), (Object)tag.name());
        this.componentTagStoreManager.getStoreForRepository(repository).deleteComponentTag(component, tag);
        disassociated.add(this.coordinateMapOf(component));
        return disassociated;
    }

    private List<Map<String, String>> disassociate(Tag tag, Iterable<ComponentSearchResult> searchHits) {
        return StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.disassociateById(tag, this.getRepository((ComponentSearchResult)hit), (EntityId)new DetachedEntityId(hit.getId())).stream()).collect(Collectors.toList());
    }

    private Tag getOrThrowNotFound(String name) {
        return Optional.ofNullable(this.get(name)).orElseThrow(() -> new TagNotFoundException(name));
    }

    private void checkAttributesSize(Map<String, Object> attributes) {
        if (attributes == null) {
            return;
        }
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(attributes);
            if (bytes.length > this.maxJsonAttributesSize) {
                throw new TagAttributesTooLargeException(this.maxJsonAttributesSize);
            }
        }
        catch (JsonProcessingException e) {
            this.log.error("Error processing size of tag attributes", (Throwable)e);
        }
    }

    private void checkExists(String name) {
        if (Optional.ofNullable(this.get(name)).isPresent()) {
            throw new TagAlreadyExistsException(name);
        }
    }

    private List<Map<String, String>> associate(Tag tag, Iterable<ComponentSearchResult> searchHits) {
        return StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.maybeAssociateById(tag, this.getRepository((ComponentSearchResult)hit), (EntityId)new DetachedEntityId(hit.getId())).stream()).collect(Collectors.toList());
    }

    private List<Map<String, String>> associateById(Tag tag, Repository repository, EntityId componentId) {
        ArrayList<Map<String, String>> associated = new ArrayList<Map<String, String>>();
        Component component = this.getComponent(repository, componentId);
        this.componentTagStoreManager.getStoreForRepository(repository).createComponentTag(component, tag);
        associated.add(this.coordinateMapOf(component));
        return associated;
    }

    private List<Map<String, String>> maybeAssociateById(Tag tag, Repository repository, EntityId componentId) {
        Component component = this.getComponent(repository, componentId);
        this.componentTagStoreManager.getStoreForRepository(repository).maybeCreateComponentTag(component, tag);
        return Collections.singletonList(this.coordinateMapOf(component));
    }

    private Component getComponent(Repository repository, EntityId componentId) {
        return (Component)((ContentFacet)repository.facet(ContentFacet.class)).components().find(componentId).orElseThrow(ComponentsNotFoundException::new);
    }

    private Repository getRepository(ComponentSearchResult hit) {
        return this.repositoryManager.get(hit.getRepositoryName());
    }

    private Map<String, String> coordinateMapOf(Component component) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)NAME, (Object)component.name());
        this.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::namespace, GROUP);
        this.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::version, VERSION);
        return builder.build();
    }

    private void maybePut(ImmutableMap.Builder<String, String> builder, Component component, Function<Component, String> f, String key) {
        Optional.of(component).map(f).ifPresent(v -> {
            ImmutableMap.Builder builder2 = builder.put((Object)key, v);
        });
    }

    private Boolean isValidContinuationToken(String continuationToken) {
        if (continuationToken == null) {
            return true;
        }
        try {
            Integer.valueOf(continuationToken);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

