/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore.api;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.api.TagComponentXO;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStore;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.decorator.DecoratorUtils;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.rest.ComponentsResourceExtension;
import org.sonatype.nexus.repository.rest.api.ComponentXO;

@Named
@Singleton
public class DatastoreTagComponentsResourceExtension
implements ComponentsResourceExtension {
    final int tagLimit;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final TagStore tagStore;

    @Inject
    public DatastoreTagComponentsResourceExtension(@Named(value="${nexus.export.browseTagsLimit:-1000}") @Named(value="${nexus.export.browseTagsLimit:-1000}") int tagLimit, ComponentTagStoreManager componentTagStoreManager, TagStore tagStore) {
        this.tagLimit = tagLimit;
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
    }

    public ComponentXO updateComponentXO(ComponentXO componentXO, FluentComponent component) {
        TagComponentXO tagComponentXO = (TagComponentXO)((Object)DecoratorUtils.getDecoratedEntity((Object)componentXO, TagComponentXO.class));
        if (tagComponentXO == null) {
            return componentXO;
        }
        ComponentTagStore<?> storeForRepository = this.componentTagStoreManager.getStoreForRepository(component.repository());
        Continuation<ComponentTag> componentTags = storeForRepository.browseComponentTags((Component)component, this.tagLimit, null);
        List<Tag> tags = this.tagStore.getByIds(componentTags.stream().map(ComponentTag::getTagId).collect(Collectors.toSet()));
        if (tags.isEmpty()) {
            return componentXO;
        }
        tagComponentXO.setTags(tags.stream().map(Tag::name).collect(Collectors.toSet()));
        return componentXO;
    }
}

