/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagEvent;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.TagCreatedEvent;
import com.sonatype.nexus.tags.datastore.TagDAO;
import com.sonatype.nexus.tags.datastore.TagData;
import com.sonatype.nexus.tags.datastore.TagDeletedEvent;
import com.sonatype.nexus.tags.datastore.TagUpdatedEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class TagStoreImpl
extends ContentStoreSupport<TagDAO>
implements TagStore {
    private static final int DEFAULT_PAGE_SIZE = 10;
    public static final String DATASTORE_TAG_STORE = "mybatis";
    private final EventManager eventManager;

    @Inject
    public TagStoreImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier, "nexus", TagDAO.class);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public Tag newTag() {
        return new TagData();
    }

    @Override
    @Transactional
    public List<Tag> getTagsForCleanup(Integer firstCreatedDaysOld, Integer lastUpdatedDaysOld, Pattern nameRegex) {
        String stringNameRegex = Strings.isNullOrEmpty((String)nameRegex.pattern()) ? null : nameRegex.pattern();
        return ImmutableList.copyOf(((TagDAO)this.dao()).query(stringNameRegex, firstCreatedDaysOld, lastUpdatedDaysOld));
    }

    @Override
    @Transactional
    public List<Tag> list() {
        return ImmutableList.copyOf(((TagDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public List<Tag> browse(QueryOptions queryOptions) {
        int limit = Optional.ofNullable(queryOptions.getLimit()).orElse(10);
        String continuationToken = Optional.ofNullable(queryOptions.getLastId()).orElse(null);
        return ImmutableList.copyOf(((TagDAO)this.dao()).browse(limit, continuationToken));
    }

    @Override
    public String getContinuationToken(List<Tag> page) {
        return String.valueOf(((TagData)Iterables.getLast(page)).id());
    }

    @Override
    @Transactional
    public Tag get(String name) {
        return ((TagDAO)this.dao()).read(name).orElse(null);
    }

    @Override
    @Transactional
    public List<Tag> get(Set<String> name) {
        return name.stream().map(this::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public List<Tag> getByIds(Set<Integer> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TagDAO)this.dao()).readByIds(ids));
    }

    @Override
    @Transactional
    public void create(@Valid Tag tag) {
        ((TagDAO)this.dao()).create((TagData)tag);
        this.postCommitEvent(() -> new TagCreatedEvent(tag));
    }

    @Override
    @Transactional
    public void update(@Valid Tag tag) {
        ((TagDAO)this.dao()).update((TagData)tag);
        this.postCommitEvent(() -> new TagUpdatedEvent(tag));
    }

    @Override
    @Transactional
    public void delete(Tag tag) {
        ((TagDAO)this.dao()).delete(tag.name());
        this.postCommitEvent(() -> new TagDeletedEvent(tag));
    }

    private void postCommitEvent(Supplier<TagEvent> tagEventSupplier) {
        this.thisSession().postCommit(() -> this.eventManager.post(tagEventSupplier.get()));
    }
}

