/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sonatype.nexus.tags.Tag;
import java.time.OffsetDateTime;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.ContinuationAware;
import org.sonatype.nexus.common.time.DateHelper;

public class TagData
implements ContinuationAware,
Tag {
    @JsonIgnore
    Integer id;
    @JsonProperty
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @Size(min=1, max=256)
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @Size(min=1, max=256) String name;
    @JsonProperty
    private NestedAttributesMap attributes;
    @JsonProperty
    private OffsetDateTime firstCreated;
    @JsonProperty
    private OffsetDateTime lastUpdated;

    public Integer id() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Tag name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public NestedAttributesMap attributes() {
        return this.attributes;
    }

    @Override
    public Tag attributes(NestedAttributesMap attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public DateTime firstCreated() {
        return DateHelper.toDateTime((OffsetDateTime)this.firstCreated);
    }

    public Tag setFirstCreated(OffsetDateTime firstCreated) {
        this.firstCreated = firstCreated;
        return this;
    }

    @Override
    public DateTime lastUpdated() {
        return DateHelper.toDateTime((OffsetDateTime)this.lastUpdated);
    }

    public Tag setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public String nextContinuationToken() {
        return Integer.toString(this.id);
    }
}

