/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.service.TagNotFoundException;
import com.sonatype.nexus.tags.service.TagService;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.ComponentUploadExtension;
import org.sonatype.nexus.repository.upload.ComponentUpload;

@Singleton
@Named
public class TagComponentUploadExtension
extends ComponentSupport
implements ComponentUploadExtension {
    private final TagService tagService;
    private final boolean disallowExistingTagAssociation;

    @Inject
    public TagComponentUploadExtension(TagService tagService, @Named(value="${nexus.upload.disallowExistingTagAssociation:-false}") @Named(value="${nexus.upload.disallowExistingTagAssociation:-false}") boolean disallowExistingTagAssociation) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.disallowExistingTagAssociation = disallowExistingTagAssociation;
    }

    public void apply(Repository repository, ComponentUpload componentUpload, Collection<EntityId> componentIds) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)componentUpload);
        Preconditions.checkNotNull(componentIds);
        this.componentUploadTag(componentUpload).ifPresent(tag -> componentIds.forEach(componentId -> {
            if (this.disallowExistingTagAssociation) {
                this.tagService.associateById((String)tag, repository, (EntityId)componentId);
            } else {
                this.tagService.maybeAssociateById((String)tag, repository, (EntityId)componentId);
            }
        }));
    }

    public void validate(ComponentUpload componentUpload) {
        this.componentUploadTag((ComponentUpload)Preconditions.checkNotNull((Object)componentUpload)).ifPresent(s -> {
            Tag realTag = this.tagService.get((String)s);
            if (realTag == null) {
                throw new TagNotFoundException((String)s);
            }
        });
    }

    private Optional<String> componentUploadTag(ComponentUpload componentUpload) {
        return Optional.ofNullable(componentUpload.getField("tag"));
    }
}

