/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.datastore;

import com.google.inject.assistedinject.Assisted;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagCreatedEvent;
import com.sonatype.nexus.tags.datastore.ComponentTagDAO;
import com.sonatype.nexus.tags.datastore.ComponentTagDeletedEvent;
import com.sonatype.nexus.tags.service.ComponentTagAlreadyExistsException;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.store.ContentStoreEventSupport;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class ComponentTagStore<DAO extends ComponentTagDAO>
extends ContentStoreEventSupport<DAO> {
    @Inject
    public ComponentTagStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<DAO> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public void createComponentTag(Component component, Tag tag) {
        this.checkExists(component, tag);
        ((ComponentTagDAO)this.dao()).createComponentTag(InternalIds.internalComponentId((Component)component), tag, null);
        this.validateTagExistenceAndNotify(component, tag);
    }

    @Transactional
    public void maybeCreateComponentTag(Component component, Tag tag) {
        ((ComponentTagDAO)this.dao()).maybeCreateComponentTag(InternalIds.internalComponentId((Component)component), tag);
        this.validateTagExistenceAndNotify(component, tag);
    }

    private void validateTagExistenceAndNotify(Component component, Tag tag) {
        int repositoryId = InternalIds.contentRepositoryId((RepositoryContent)component);
        this.read(component, tag).ifPresent(componentTag -> this.postCommitEvent(() -> new ComponentTagCreatedEvent((ComponentTag)componentTag, repositoryId)));
    }

    @Transactional
    public void deleteComponentTag(Component component, Tag tag) {
        this.read(component, tag).ifPresent(componentTag -> {
            ((ComponentTagDAO)this.dao()).delete(InternalIds.internalComponentId((Component)component), tag);
            this.postCommitEvent(() -> new ComponentTagDeletedEvent((ComponentTag)componentTag, InternalIds.contentRepositoryId((RepositoryContent)component)));
        });
    }

    @Transactional
    public Collection<Integer> findTaggedComponentIds(Tag tag, int repositoryId) {
        return ((ComponentTagDAO)this.dao()).findTaggedComponentIdsForRepository(tag, repositoryId);
    }

    @Transactional
    public Continuation<ComponentTag> browseComponentTags(Component component, int limit, @Nullable String continuationToken) {
        return ((ComponentTagDAO)this.dao()).browseComponentTags(InternalIds.internalComponentId((Component)component), limit, continuationToken);
    }

    @Transactional
    public Optional<ComponentTag> read(Component component, Tag tag) {
        return ((ComponentTagDAO)this.dao()).read(InternalIds.internalComponentId((Component)component), tag);
    }

    private void checkExists(Component component, Tag tag) {
        if (this.read(component, tag).isPresent()) {
            throw new ComponentTagAlreadyExistsException(component.name(), component.version(), tag.name());
        }
    }
}

