/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.api.internal;

import com.sonatype.nexus.tags.api.BaseTagXO;
import com.sonatype.nexus.tags.api.TagXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.sonatype.nexus.rest.Page;

@Api(value="Tags")
public interface TagsResourceDoc {
    @ApiOperation(value="List tags")
    public Page<TagXO> getTags(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned") String var1);

    @ApiOperation(value="Get a tag")
    @ApiResponses(value={@ApiResponse(code=404, message="Tag not found")})
    public TagXO get(@ApiParam(value="Name of the tag to retrieve") String var1);

    @ApiOperation(value="Create a tag")
    @ApiResponses(value={@ApiResponse(code=200, message="Tag was added"), @ApiResponse(code=400, message="Bad request. Check tag name and attributes. Name can only contain letters, numbers, underscores, hyphens and dots and cannot start with an underscore or dot. The name cannot exceed 256 characters. The attributes is a JSON document which cannot exceed 20k.")})
    public TagXO create(@NotNull @Valid TagXO var1);

    @ApiOperation(value="Associate components with a tag")
    @ApiResponses(value={@ApiResponse(code=200, message="Associate was successful"), @ApiResponse(code=404, message="Tag or components not found")})
    public Response associate(@ApiParam(name="tagName", type="string", value="Tag to associate to the matched components", required=true) String var1, @Context UriInfo var2, @ApiParam(value="The query waits until the indexing is complete", defaultValue="true") boolean var3);

    @ApiOperation(value="Disassociate components from a tag")
    @ApiResponses(value={@ApiResponse(code=200, message="Disassociation was successful"), @ApiResponse(code=404, message="Tag or components not found")})
    public Response disassociate(@ApiParam(name="tagName", type="string", value="Tag to associate to the matched components", required=true) String var1, @Context UriInfo var2);

    @ApiResponses(value={@ApiResponse(code=404, message="Tag not found"), @ApiResponse(code=400, message="Bad request. Check tag attributes. The attributes is a JSON document which cannot exceed 20k")})
    @ApiOperation(value="Update a tags attributes")
    public TagXO replace(String var1, @NotNull @Valid BaseTagXO var2);

    @ApiOperation(value="Delete a tag")
    @ApiResponses(value={@ApiResponse(code=204, message="Tag was deleted"), @ApiResponse(code=404, message="Tag not found")})
    public void delete(@ApiParam(value="Name of the tag to delete") String var1);
}

