/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.api.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.api.BaseTagXO;
import com.sonatype.nexus.tags.api.TagXO;
import com.sonatype.nexus.tags.api.internal.TagsResourceDoc;
import com.sonatype.nexus.tags.service.TagService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.rest.NoQueryParamException;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SearchUtils;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.SimpleApiResponse;

@Named
@Singleton
@Path(value="/v1/tags")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TagsResource
extends ComponentSupport
implements Resource,
TagsResourceDoc {
    public static final String RESOURCE_URI = "/v1/tags";
    public static final String ASSOCIATE_URI = "/associate/{tagName}";
    private static final String WAIT = "wait";
    static final String TAG_NAME = "tagName";
    static final String ASSOCIATION_SUCCESSFUL = "Association successful";
    static final String DISASSOCIATION_SUCCESSFUL = "Disassociation successful";
    static final String COMPONENTS_ASSOCIATED = "components associated";
    static final String COMPONENTS_DISASSOCIATED = "components disassociated";
    private final TagService tagService;
    private final SearchService searchService;
    private final SearchUtils searchUtils;

    @Inject
    public TagsResource(TagService tagService, SearchService searchService, SearchUtils searchUtils) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.searchUtils = (SearchUtils)Preconditions.checkNotNull((Object)searchUtils);
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:tags:read"})
    public Page<TagXO> getTags(@QueryParam(value="continuationToken") String continuationToken) {
        PageResult<Tag> tagBrowseResult = this.tagService.browse(continuationToken);
        List tagXOs = tagBrowseResult.getResults().stream().map(this::fromTag).collect(Collectors.toList());
        String newContinuationToken = null;
        if (tagBrowseResult.getTotal() > (long)tagBrowseResult.getResults().size()) {
            newContinuationToken = this.tagService.getContinuationToken(tagBrowseResult);
        }
        return new Page(tagXOs, newContinuationToken);
    }

    @Override
    @GET
    @Path(value="/{name}")
    @RequiresPermissions(value={"nexus:tags:read"})
    public TagXO get(@PathParam(value="name") String name) {
        return this.fromTag(this.tagService.require(name));
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tags:create"})
    public TagXO create(@NotNull @Valid TagXO tagXO) {
        return this.fromTag(this.tagService.create(tagXO.getName(), tagXO.getAttributes()));
    }

    @Override
    @POST
    @Path(value="/associate/{tagName}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tags:associate"})
    public Response associate(@PathParam(value="tagName") String tagName, @Context UriInfo uriInfo, @DefaultValue(value="true") @QueryParam(value="wait") boolean wait) {
        if (uriInfo.getQueryParameters().isEmpty()) {
            throw new NoQueryParamException();
        }
        this.waitIfEnabled(wait);
        List filters = this.searchUtils.getSearchFilters(uriInfo).stream().filter(filter -> !WAIT.equals(filter.getProperty())).collect(Collectors.toList());
        SearchRequest request = SearchRequest.builder().searchFilters(filters).build();
        Iterable components = this.searchService.browse(request);
        return SimpleApiResponse.ok((String)ASSOCIATION_SUCCESSFUL, (Object)ImmutableMap.of((Object)COMPONENTS_ASSOCIATED, this.tagService.associate(tagName, components)));
    }

    private void waitIfEnabled(boolean wait) {
        if (wait) {
            this.log.debug("waiting for a calm period before searching");
            this.searchService.waitForCalm();
        }
    }

    @Override
    @DELETE
    @Path(value="/associate/{tagName}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tags:disassociate"})
    public Response disassociate(@PathParam(value="tagName") String tagName, @Context UriInfo uriInfo) {
        if (uriInfo.getQueryParameters().isEmpty()) {
            throw new NoQueryParamException();
        }
        SearchRequest request = SearchRequest.builder().searchFilters((Collection)this.searchUtils.getSearchFilters(uriInfo)).build();
        Iterable components = this.searchService.browse(request);
        return SimpleApiResponse.ok((String)DISASSOCIATION_SUCCESSFUL, (Object)ImmutableMap.of((Object)COMPONENTS_DISASSOCIATED, this.tagService.disassociate(tagName, components)));
    }

    @Override
    @PUT
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tags:update"})
    public TagXO replace(@PathParam(value="name") String name, @NotNull @Valid BaseTagXO tagXO) {
        return this.fromTag(this.tagService.update(name, tagXO.getAttributes()));
    }

    @Override
    @DELETE
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tags:delete"})
    public void delete(@PathParam(value="name") String name) {
        this.tagService.delete(name);
    }

    private TagXO fromTag(Tag tag) {
        TagXO tagXO = new TagXO();
        tagXO.setName(tag.name());
        tagXO.setAttributes(tag.attributes().backing());
        tagXO.setFirstCreated(tag.firstCreated().toDate());
        tagXO.setLastUpdated(tag.lastUpdated().toDate());
        return tagXO;
    }
}

