/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTask;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskConfiguration;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskValidator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@AvailabilityVersion(from="1.0")
@Named
@Singleton
public class BlobStoreGroupMemberRemovalTaskDescriptor
extends TaskDescriptorSupport {
    public static final String FROM_GROUP = "fromGroup";
    public static final String MEMBER_TO_REMOVE = "memberToRemove";
    public static final String TYPE_ID = "blobstore.group.memberRemoval";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreGroupService blobStoreGroupService;
    private final List<BlobStoreGroupMemberRemovalTaskValidator> validators;

    @Inject
    public BlobStoreGroupMemberRemovalTaskDescriptor(BlobStoreGroupService blobStoreGroupService, List<BlobStoreGroupMemberRemovalTaskValidator> validators) {
        super(TYPE_ID, BlobStoreGroupMemberRemovalTask.class, messages.name(), true, true, true, new FormField[]{new ComboboxFormField(FROM_GROUP, messages.groupLabel(), messages.groupHelpText(), true).withStoreApi("coreui_Blobstore.readGroups").withIdMapping("name"), new ComboboxFormField(MEMBER_TO_REMOVE, messages.memberLabel(), messages.memberHelpText(), true).withIdMapping("name")});
        this.blobStoreGroupService = (BlobStoreGroupService)Preconditions.checkNotNull((Object)blobStoreGroupService);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    public boolean isVisible() {
        return this.blobStoreGroupService.isEnabled() && super.isVisible();
    }

    public boolean isExposed() {
        return this.blobStoreGroupService.isEnabled() && super.isExposed();
    }

    public TaskConfiguration createTaskConfiguration() {
        return new BlobStoreGroupMemberRemovalTaskConfiguration(this.validators);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Remove a member from a blob store group")
        public String name();

        @MessageBundle.DefaultMessage(value="Group")
        public String groupLabel();

        @MessageBundle.DefaultMessage(value="Select the blob store group")
        public String groupHelpText();

        @MessageBundle.DefaultMessage(value="Blob store")
        public String memberLabel();

        @MessageBundle.DefaultMessage(value="Select the group member to remove")
        public String memberHelpText();
    }
}

