/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskConfiguration;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobInputStreamException;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.scheduling.TaskUtils;
import org.sonatype.nexus.thread.NexusForkJoinPoolFactory;

@Named
public class BlobStoreGroupMemberRemovalTask
extends TaskSupport
implements Cancelable {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final ProgressLogIntervalHelper intervalLogger;
    private final BlobStoreManager manager;
    private final ForkJoinPool forkJoinPool;
    private final BlobStoreGroupService blobStoreGroupService;
    private final ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore;
    private final TaskUtils taskUtils;
    private final List<BlobStoreGroupMemberRemovalTaskValidator> validators;
    private static int chunkSize = 128;

    @Inject
    public BlobStoreGroupMemberRemovalTask(BlobStoreManager manager, BlobStoreGroupService blobStoreGroupService, ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore, TaskUtils taskUtils, List<BlobStoreGroupMemberRemovalTaskValidator> validators) {
        this.manager = (BlobStoreManager)Preconditions.checkNotNull((Object)manager);
        this.taskUtils = (TaskUtils)Preconditions.checkNotNull((Object)taskUtils);
        this.intervalLogger = new ProgressLogIntervalHelper(this.log, 15);
        this.forkJoinPool = NexusForkJoinPoolFactory.createForkJoinPool((String)"blob-store-group-removal-");
        this.blobStoreGroupService = (BlobStoreGroupService)Preconditions.checkNotNull((Object)blobStoreGroupService);
        this.changeRepositoryBlobStoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobStoreStore);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    public String getMessage() {
        return messages.message();
    }

    public Object execute() throws Exception {
        try {
            BlobStoreGroupMemberRemovalTaskConfiguration configuration = new BlobStoreGroupMemberRemovalTaskConfiguration(this.validators, this.taskConfiguration());
            this.process(configuration);
            return null;
        }
        catch (Exception e) {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "unexpected error executing task : {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void process(BlobStoreGroupMemberRemovalTaskConfiguration configuration) throws Exception {
        String groupName = configuration.getFromGroup();
        String memberToRemove = configuration.getMemberToRemove();
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "deleting member {} from group {}", (Object)memberToRemove, (Object)groupName);
        for (BlobStoreGroupMemberRemovalTaskValidator validator : this.validators) {
            validator.validate(configuration);
        }
        this.taskUtils.checkForConflictingTasks(this.getId(), this.getName(), Arrays.asList("repository.move"), (Map)ImmutableMap.of((Object)"moveInitialBlobstore", Arrays.asList(memberToRemove, groupName), (Object)"moveTargetBlobstore", Arrays.asList(memberToRemove, groupName)));
        List movingRepositories = this.changeRepositoryBlobStoreStore.findByBlobStoreName(memberToRemove);
        if (movingRepositories != null && !movingRepositories.isEmpty()) {
            String names = movingRepositories.stream().map(ChangeRepositoryBlobStoreConfiguration::getName).collect(Collectors.joining(", "));
            throw new IllegalStateException("Cannot start task '" + this.getName() + "' as there is at least one repository being moved (" + names + ") that is related to blobstore '" + memberToRemove + "'. Please restart this task once the other(s) complete.");
        }
        if (!this.blobStoreGroupService.isEnabled()) {
            throw new IllegalStateException("Blob store groups are not enabled");
        }
        BlobStore group = (BlobStore)Preconditions.checkNotNull((Object)this.manager.get(groupName));
        BlobStore src = (BlobStore)Preconditions.checkNotNull((Object)this.manager.get(memberToRemove));
        Preconditions.checkArgument((boolean)(group instanceof BlobStoreGroup), (Object)String.format("'%s' must be a Blob Store Group.", groupName));
        List members = ((BlobStoreGroup)group).getMembers();
        long availableCount = members.stream().filter(blobStore -> !blobStore.getBlobStoreConfiguration().getName().equals(memberToRemove)).filter(BlobStore::isWritable).count();
        Preconditions.checkArgument((availableCount > 0L ? 1 : 0) != 0, (Object)"One or more other blob store member must be available in the group.");
        Preconditions.checkArgument((boolean)members.contains(src), (Object)String.format("'%s' must be a member of group '%s'.", memberToRemove, groupName));
        this.setSourceWritable(src, false);
        long initialBlobCount = src.getMetrics().getBlobCount();
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "found {} blobs on member {} , moving blobs...", (Object)initialBlobCount, (Object)memberToRemove);
        AtomicLong processed = new AtomicLong(0L);
        Consumer<BlobId> blobIdConsumer = blobId -> {
            try {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "moving blobId {} from {} to {}", new Object[]{blobId, memberToRemove, groupName});
                this.manager.moveBlob(blobId, src, group);
                this.intervalLogger.info("Elapsed time: {}, Total processed {}/{}", new Object[]{this.intervalLogger.getElapsed(), processed.incrementAndGet(), initialBlobCount});
            }
            catch (BlobInputStreamException e) {
                src.delete(e.getBlobId(), e.getMessage());
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Failure moving blobId {} , error : {}", blobId, (Object)e.getMessage());
                this.log.warn(e.getMessage());
            }
        };
        try {
            try {
                this.processBlobs(src, blobIdConsumer);
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Finished blobs transfer, Elapsed time: {}, Total processed: {}/{}", new Object[]{this.intervalLogger.getElapsed(), processed.get(), initialBlobCount});
            }
            catch (CancellationException e) {
                this.log.info("Tasks execution pool has been cancelled. isCanceled: {}", (Object)this.isCanceled(), (Object)e);
                throw new TaskInterruptedException("Task has been interrupted", this.isCanceled());
            }
            catch (ExecutionException e) {
                this.log.error("Member removal task did not complete successfully", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (!this.forkJoinPool.isShutdown()) {
                this.forkJoinPool.shutdown();
            }
        }
        if (this.isCanceled()) {
            throw new TaskInterruptedException("Task has been interrupted", this.isCanceled());
        }
        this.removeMemberFromGroup(memberToRemove, group);
        this.setSourceWritable(src, true);
    }

    private void processBlobs(BlobStore src, Consumer<BlobId> blobIdConsumer) throws InterruptedException, ExecutionException {
        List chunk;
        List directPathIds = src.getDirectPathBlobIdStream("").collect(Collectors.toList());
        String blobStoreName = src.getBlobStoreConfiguration().getName();
        AtomicLong totalCount = new AtomicLong();
        do {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Stream stream = src.getBlobIdStream();){
                chunk = stream.filter(id -> {
                    boolean applies = true;
                    if (directPathIds.contains(id)) {
                        this.log.trace(TaskLoggingMarkers.TASK_LOG_ONLY, "ignoring blobId {} since it is part of the direct paths of the blobstore {}", id, (Object)blobStoreName);
                        applies = false;
                    }
                    return applies;
                }).limit(chunkSize).collect(Collectors.toList());
                if (chunk.isEmpty()) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "No blobs to process");
                }
                Stream chunkStream = chunk.stream();
                ((ForkJoinTask)this.forkJoinPool.submit(() -> ((Stream)chunkStream.parallel()).forEach(blobIdConsumer))).get();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "processed chunk with {} blobs", (Object)chunk.size());
            totalCount.getAndAdd(chunk.size());
        } while (chunk.size() == chunkSize);
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "finished transfer - processed blobs count: {}", (Object)totalCount);
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "ignored direct path blobs count: {}", (Object)directPathIds.size());
    }

    private void setSourceWritable(BlobStore src, boolean writable) throws Exception {
        BlobStoreConfiguration blobStoreConfiguration = src.getBlobStoreConfiguration();
        blobStoreConfiguration.setWritable(writable);
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "set writable state of blobstore {} to {}", (Object)src.getBlobStoreConfiguration().getName(), (Object)writable);
        this.manager.update(blobStoreConfiguration);
    }

    private void removeMemberFromGroup(String memberToRemove, BlobStore group) throws Exception {
        BlobStoreConfiguration groupConfig = group.getBlobStoreConfiguration();
        ArrayList memberNames = new ArrayList(BlobStoreGroupConfigurationHelper.memberNames((BlobStoreConfiguration)groupConfig));
        memberNames.remove(memberToRemove);
        groupConfig.attributes("group").set("members", memberNames);
        this.manager.update(groupConfig);
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "deleted member {} from group {}", (Object)memberToRemove, (Object)groupConfig.getName());
    }

    public void cancel() {
        super.cancel();
        this.forkJoinPool.shutdownNow();
        BlobStore member = Optional.of(this.getConfiguration()).map(c -> c.getString("memberToRemove")).map(arg_0 -> ((BlobStoreManager)this.manager).get(arg_0)).orElseThrow(() -> new IllegalStateException("Unable to find member to be removed"));
        try {
            this.setSourceWritable(member, true);
        }
        catch (Exception e) {
            this.log.error("Failed to clear read only attribute on blob store '{}' when job was cancelled", (Object)member.getBlobStoreConfiguration().getName(), (Object)e);
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Run blob store group member removal task")
        public String message();
    }
}

