/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiModel;

public class GroupBlobStoreApiModel
extends BlobStoreApiModel {
    @ApiModelProperty(value="List of the names of blob stores that are members of this group")
    private List<String> members;
    @ApiModelProperty(allowableValues="roundRobin,writeToFirst")
    private String fillPolicy;

    public GroupBlobStoreApiModel() {
    }

    public GroupBlobStoreApiModel(BlobStoreConfiguration configuration) {
        super(configuration);
        this.members = (List)configuration.attributes("group").get("members", List.class);
        this.fillPolicy = (String)configuration.attributes("group").get("fillPolicy", String.class);
    }

    public List<String> getMembers() {
        return this.members;
    }

    public String getFillPolicy() {
        return this.fillPolicy;
    }

    public void setFillPolicy(String fillPolicy) {
        this.fillPolicy = fillPolicy;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public BlobStoreConfiguration toBlobStoreConfiguration(BlobStoreConfiguration config) {
        BlobStoreConfiguration newConfig = super.toBlobStoreConfiguration(config);
        newConfig.setType("Group");
        newConfig.attributes("group").set("members", this.members);
        newConfig.attributes("group").set("fillPolicy", (Object)this.fillPolicy);
        return newConfig;
    }
}

