/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.internal.BlobStoreGroupFeature;
import com.sonatype.nexus.blobstore.group.internal.BlobStoreGroupServiceImpl;
import com.sonatype.nexus.licensing.ext.capability.LicensingConditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;

@Named(value="blobStoreGroup")
public class BlobStoreGroupCapability
extends CapabilitySupport<Configuration> {
    public static final String TYPE_ID = "blobStoreGroup";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"blobStoreGroup");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final LicensingConditions licensingConditions;
    private final BlobStoreGroupFeature feature;
    private final BlobStoreGroupServiceImpl blobStoreGroupService;

    @Inject
    public BlobStoreGroupCapability(LicensingConditions licensingConditions, BlobStoreGroupFeature feature, BlobStoreGroupServiceImpl blobStoreGroupService) {
        this.licensingConditions = (LicensingConditions)Preconditions.checkNotNull((Object)licensingConditions);
        this.feature = (BlobStoreGroupFeature)((Object)Preconditions.checkNotNull((Object)((Object)feature)));
        this.blobStoreGroupService = (BlobStoreGroupServiceImpl)((Object)Preconditions.checkNotNull((Object)((Object)blobStoreGroupService)));
    }

    protected Configuration createConfig(Map<String, String> properties) throws Exception {
        return new Configuration(properties);
    }

    @Nullable
    protected String renderDescription() {
        return this.context().isActive() ? messages.enabled() : messages.disabled();
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.licensingConditions.licenseIsValid((Feature)this.feature), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    public void onActivate(Configuration config) throws Exception {
        this.blobStoreGroupService.start();
    }

    public void onPassivate(Configuration config) throws Exception {
        this.blobStoreGroupService.stop();
    }

    public static class Configuration
    extends CapabilityConfigurationSupport {
        Configuration(Map<String, String> properties) {
        }
    }

    @AvailabilityVersion(from="1.0")
    @Named(value="blobStoreGroup")
    public static class Descriptor
    extends CapabilityDescriptorSupport<Configuration>
    implements Taggable {
        public Descriptor() {
            this.setExposed(false);
            this.setHidden(true);
        }

        public CapabilityType type() {
            return TYPE;
        }

        public String name() {
            return null;
        }

        public List<FormField> formFields() {
            return Collections.emptyList();
        }

        protected Configuration createConfig(Map<String, String> properties) {
            return new Configuration(properties);
        }

        protected String renderAbout() throws Exception {
            return this.render("blobStoreGroup-about.vm");
        }

        public Set<Tag> getTags() {
            return null;
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Blob Store Group")
        public String name();

        @MessageBundle.DefaultMessage(value="Blob Store Group")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();
    }
}

