/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.snapshot;

import com.orientechnologies.common.concur.ONeedRetryException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFileParser;
import org.sonatype.nexus.repository.apt.internal.debian.Release;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptFilterInputStream;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotComponentSelector;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotItem;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.OrientFacetHelper;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientAptSnapshotFacetSupport
extends FacetSupport
implements AptSnapshotFacet {
    @Override
    public boolean isSnapshotableFile(String path) {
        return !path.endsWith(".deb") && !path.endsWith(".DEB");
    }

    @Override
    public void createSnapshot(String id, SnapshotComponentSelector selector) throws IOException {
        Iterable<SnapshotItem> snapshots = this.collectSnapshotItems(selector);
        this.createSnapshot(id, snapshots);
    }

    @Transactional(retryOn={ONeedRetryException.class})
    protected void createSnapshot(String id, Iterable<SnapshotItem> snapshots) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Bucket bucket = tx.findBucket(this.getRepository());
        for (SnapshotItem item : snapshots) {
            String assetName = this.createAssetPath(id, item.specifier.path);
            Asset asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(assetName);
            try {
                Throwable throwable = null;
                Object var11_12 = null;
                try (TempBlob streamSupplier = storageFacet.createTempBlob(item.content.openInputStream(), AptFacetHelper.hashAlgorithms);){
                    AssetBlob blob = tx.createBlob(item.specifier.path, (InputStreamSupplier)streamSupplier, AptFacetHelper.hashAlgorithms, null, item.specifier.role.getMimeType(), true);
                    tx.attachBlob(asset, blob);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                item.content.close();
            }
            tx.saveAsset(asset);
        }
    }

    @Override
    @Transactional(retryOn={ONeedRetryException.class})
    @Nullable
    public Content getSnapshotFile(String id, String path) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = tx.findAssetWithProperty("name", (Object)this.createAssetPath(id, path), bucket);
        if (asset == null) {
            return null;
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        return OrientFacetHelper.toContent(asset, blob);
    }

    @Override
    @Transactional(retryOn={ONeedRetryException.class})
    public void deleteSnapshot(String id) throws IOException {
        String path = this.createAssetPath(id, "");
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Query query = Query.builder().where("name").like((Object)(String.valueOf(path) + "%")).build();
        tx.findAssets(query, Collections.singletonList(this.getRepository())).spliterator().forEachRemaining(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
    }

    protected Iterable<SnapshotItem> collectSnapshotItems(SnapshotComponentSelector selector) throws IOException {
        Release release;
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        ArrayList<SnapshotItem> result = new ArrayList<SnapshotItem>();
        boolean isFlat = aptFacet.isFlat();
        String distribution = aptFacet.getDistribution();
        List<SnapshotItem> releaseIndexItems = this.fetchSnapshotItems(AptFacetHelper.getReleaseIndexSpecifiers(isFlat, distribution));
        HashMap<SnapshotItem.Role, SnapshotItem> itemsByRole = new HashMap<SnapshotItem.Role, SnapshotItem>(releaseIndexItems.stream().collect(Collectors.toMap(item -> item.specifier.role, item -> item)));
        InputStream releaseStream = null;
        if (itemsByRole.containsKey((Object)SnapshotItem.Role.RELEASE_INDEX)) {
            releaseStream = ((SnapshotItem)itemsByRole.get((Object)((Object)SnapshotItem.Role.RELEASE_INDEX))).content.openInputStream();
        } else {
            InputStream is = ((SnapshotItem)itemsByRole.get((Object)((Object)SnapshotItem.Role.RELEASE_INLINE_INDEX))).content.openInputStream();
            if (is != null) {
                ArmoredInputStream aIs = new ArmoredInputStream(is);
                releaseStream = new AptFilterInputStream(aIs);
            }
        }
        if (releaseStream == null) {
            throw new IOException("Invalid upstream repository: no release index present");
        }
        try {
            ControlFile index = new ControlFileParser().parseControlFile(releaseStream);
            release = new Release(index);
        }
        finally {
            releaseStream.close();
        }
        result.addAll(releaseIndexItems);
        if (isFlat) {
            result.addAll(this.fetchSnapshotItems(AptFacetHelper.getReleasePackageIndexes(isFlat, distribution, null, null)));
        } else {
            List<String> archs = selector.getArchitectures(release);
            List<String> comps = selector.getComponents(release);
            for (String arch : archs) {
                for (String comp : comps) {
                    result.addAll(this.fetchSnapshotItems(AptFacetHelper.getReleasePackageIndexes(isFlat, distribution, comp, arch)));
                }
            }
        }
        return result;
    }

    private String createAssetPath(String id, String path) {
        return "snapshots/" + id + "/" + path;
    }

    protected abstract List<SnapshotItem> fetchSnapshotItems(List<SnapshotItem.ContentSpecifier> var1) throws IOException;
}

