/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted.metadata;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.internal.hosted.CompressingTempFileStore;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="apt")
@Facet.Exposed
public class OrientAptHostedMetadataFacet
extends FacetSupport {
    private final Clock clock;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;
    private static final String REBUILD_COOPERATION_KEY = "rebuild-apt-metadata";
    private static final String P_INDEX_SECTION = "index_section";
    private static final String P_ARCHITECTURE = "architecture";
    private static final String SELECT_HOSTED_ASSETS = "SELECT name, attributes.apt.index_section AS index_section, attributes.apt.architecture AS architecture FROM asset WHERE bucket=:bucket AND attributes.apt.asset_kind=:asset_kind";

    @Inject
    public OrientAptHostedMetadataFacet(Clock clock, Cooperation2Factory cooperationFactory, @Named(value="${nexus.apt.metadata.cooperation.enabled:-true}") @Named(value="${nexus.apt.metadata.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.apt.metadata.cooperation.majorTimeout:-0s}") @Named(value="${nexus.apt.metadata.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.apt.metadata.cooperation.minorTimeout:-30s}") @Named(value="${nexus.apt.metadata.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.apt.metadata.cooperation.threadsPerKey:-100}") @Named(value="${nexus.apt.metadata.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":repomd");
    }

    public void invalidateMetadata() {
        this.log.debug("Invalidating repository metadata: {}", (Object)this.getRepository().getName());
        try {
            ((OrientAptFacet)this.getRepository().facet(OrientAptFacet.class)).delete(this.releaseIndexName("InRelease"));
        }
        catch (IOException e) {
            this.log.error("Failed to invalidate repository metadata: {}", (Object)this.getRepository().getName(), (Object)e);
        }
    }

    public Optional<Content> rebuildMetadata(List<OrientAptHostedFacet.AssetChange> changeList) throws IOException {
        return Optional.ofNullable((Content)this.cooperation.on(() -> this.doRebuildMetadata(changeList)).cooperate(REBUILD_COOPERATION_KEY, new String[0]));
    }

    @TransactionalStoreMetadata
    Content doRebuildMetadata(List<OrientAptHostedFacet.AssetChange> changes) throws IOException {
        String releaseFile;
        this.log.debug("Starting rebuilding metadata at {}", (Object)this.getRepository().getName());
        OffsetDateTime rebuildStart = this.clock.clusterTime();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        AptSigningFacet signingFacet = (AptSigningFacet)this.getRepository().facet(AptSigningFacet.class);
        Bucket bucket = tx.findBucket(this.getRepository());
        StringBuilder sha256Builder = new StringBuilder();
        StringBuilder md5Builder = new StringBuilder();
        Throwable throwable = null;
        Object var11_11 = null;
        try (CompressingTempFileStore store = this.buildPackageIndexes(tx, bucket, changes);){
            for (Map.Entry<String, CompressingTempFileStore.FileMetadata> entry : store.getFiles().entrySet()) {
                Content plainContent = aptFacet.put(this.packageIndexName(entry.getKey(), ""), (Payload)new StreamPayload(entry.getValue().plainSupplier(), entry.getValue().plainSize(), "text/plain"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, plainContent, this.packageRelativeIndexName(entry.getKey(), ""));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, plainContent, this.packageRelativeIndexName(entry.getKey(), ""));
                Content gzContent = aptFacet.put(this.packageIndexName(entry.getKey(), ".gz"), (Payload)new StreamPayload(entry.getValue().gzSupplier(), entry.getValue().bzSize(), "application/gzip"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, gzContent, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, gzContent, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                Content bzContent = aptFacet.put(this.packageIndexName(entry.getKey(), ".bz2"), (Payload)new StreamPayload(entry.getValue().bzSupplier(), entry.getValue().bzSize(), "application/bzip2"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, bzContent, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, bzContent, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
            }
            releaseFile = this.buildReleaseFile(aptFacet.getDistribution(), store.getFiles().keySet(), md5Builder.toString(), sha256Builder.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Content releaseFileContent = aptFacet.put(this.releaseIndexName("Release"), (Payload)new BytesPayload(releaseFile.getBytes(Charsets.UTF_8), "text/plain"));
        byte[] inRelease = signingFacet.signInline(releaseFile);
        aptFacet.put(this.releaseIndexName("InRelease"), (Payload)new BytesPayload(inRelease, "text/plain"));
        byte[] releaseGpg = signingFacet.signExternal(releaseFile);
        aptFacet.put(this.releaseIndexName("Release.gpg"), (Payload)new BytesPayload(releaseGpg, "application/pgp-signature"));
        if (this.log.isDebugEnabled()) {
            long finishTime = System.currentTimeMillis();
            this.log.debug("Completed metadata rebuild in {}", (Object)(finishTime - rebuildStart.toInstant().toEpochMilli()));
        }
        return releaseFileContent;
    }

    /*
     * Unable to fully structure code
     */
    private CompressingTempFileStore buildPackageIndexes(StorageTx tx, Bucket bucket, List<OrientAptHostedFacet.AssetChange> changes) throws IOException {
        result = new CompressingTempFileStore();
        streams = new HashMap<String, Writer>();
        ok = false;
        try {
            sqlParams = new HashMap<String, Object>();
            sqlParams.put("bucket", AttachedEntityHelper.id((Entity)bucket));
            sqlParams.put("asset_kind", "DEB");
            excludeNames = changes.stream().map((Function<OrientAptHostedFacet.AssetChange, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Ljava/lang/String;)()).collect(Collectors.toSet());
            browse = tx.browse("SELECT name, attributes.apt.index_section AS index_section, attributes.apt.architecture AS architecture FROM asset WHERE bucket=:bucket AND attributes.apt.asset_kind=:asset_kind", sqlParams);
            for (ODocument document : browse) {
                name = (String)document.field("name", String.class);
                arch = (String)document.field("architecture", String.class);
                outWriter = streams.computeIfAbsent(arch, (Function<String, Writer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, openOutput(java.lang.String ), (Ljava/lang/String;)Ljava/io/Writer;)((CompressingTempFileStore)result));
                if (excludeNames.contains(name)) continue;
                indexSection = (String)document.field("index_section", String.class);
                outWriter.write(indexSection);
                outWriter.write("\n\n");
            }
            addAssets = changes.stream().filter((Predicate<OrientAptHostedFacet.AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Z)()).map((Function<OrientAptHostedFacet.AssetChange, Asset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Lorg/sonatype/nexus/repository/storage/Asset;)()).collect(Collectors.toList());
            for (Asset asset : addAssets) {
                arch = (String)asset.formatAttributes().get("architecture", String.class);
                indexSection = (String)asset.formatAttributes().get("index_section", String.class);
                outWriter = streams.computeIfAbsent(arch, (Function<String, Writer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, openOutput(java.lang.String ), (Ljava/lang/String;)Ljava/io/Writer;)((CompressingTempFileStore)result));
                outWriter.write(indexSection);
                outWriter.write("\n\n");
            }
            ok = true;
        }
        finally {
            ** for (writer : streams.values())
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Writer)writer);
            continue;
        }
lbl41:
        // 1 sources

        if (!ok) {
            result.close();
        }
        return result;
    }

    private void addSignatureItem(StringBuilder builder, HashAlgorithm algo, Content content, String filename) {
        Map hashMap = (Map)content.getAttributes().get("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
        builder.append("\n ");
        builder.append(((HashCode)hashMap.get(algo)).toString());
        builder.append(" ");
        builder.append(content.getSize());
        builder.append(" ");
        builder.append(filename);
    }

    private String buildReleaseFile(String distribution, Collection<String> architectures, String md5, String sha256) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"));
        ControlFile.Paragraph p = new ControlFile.Paragraph(Arrays.asList(new ControlFile.ControlField("Suite", distribution), new ControlFile.ControlField("Codename", distribution), new ControlFile.ControlField("Components", "main"), new ControlFile.ControlField("Date", date), new ControlFile.ControlField("Architectures", String.join((CharSequence)" ", architectures)), new ControlFile.ControlField("SHA256", sha256), new ControlFile.ControlField("MD5Sum", md5)));
        return p.toString();
    }

    private String packageIndexName(String arch, String ext) {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/main/binary-" + arch + "/Packages" + ext;
    }

    private String packageRelativeIndexName(String arch, String ext) {
        return "main/binary-" + arch + "/Packages" + ext;
    }

    private String releaseIndexName(String name) {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/" + name;
    }

    private static /* synthetic */ String lambda$1(OrientAptHostedFacet.AssetChange change) {
        return change.asset.name();
    }

    private static /* synthetic */ boolean lambda$3(OrientAptHostedFacet.AssetChange change) {
        return change.action == AssetAction.ADDED;
    }

    private static /* synthetic */ Asset lambda$4(OrientAptHostedFacet.AssetChange change) {
        return change.asset;
    }
}

