/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.apt.internal.AptRecipeSupport;
import org.sonatype.nexus.repository.apt.internal.AptSecurityFacet;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningHandler;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.apt.orient.AptRestoreFacet;
import org.sonatype.nexus.repository.apt.orient.internal.OrientAptFacetImpl;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedComponentMaintenanceFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedHandler;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedSnapshotFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.metadata.OrientAptHostedMetadataFacet;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.search.ElasticSearchFacet;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.UnitOfWorkHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.FormatHighAvailabilitySupportHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.AlwaysMatcher;

@AvailabilityVersion(from="1.0")
@Named(value="apt-hosted")
@Singleton
public class OrientAptHostedRecipe
extends AptRecipeSupport {
    public static final String NAME = "apt-hosted";
    @Inject
    Provider<AptSecurityFacet> securityFacet;
    @Inject
    FormatHighAvailabilitySupportHandler highAvailabilitySupportHandler;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<OrientAptFacetImpl> aptFacet;
    @Inject
    Provider<AptRestoreFacet> aptRestoreFacet;
    @Inject
    Provider<OrientAptHostedFacet> aptHostedFacet;
    @Inject
    Provider<AptSigningFacet> aptSigningFacet;
    @Inject
    Provider<OrientAptHostedSnapshotFacet> snapshotFacet;
    @Inject
    Provider<StorageFacet> storageFacet;
    @Inject
    Provider<AttributesFacet> attributesFacet;
    @Inject
    Provider<OrientAptHostedComponentMaintenanceFacet> componentMaintenance;
    @Inject
    Provider<ElasticSearchFacet> searchFacet;
    @Inject
    Provider<OrientAptHostedMetadataFacet> aptHostedMetadataFacet;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    UnitOfWorkHandler unitOfWorkHandler;
    @Inject
    OrientAptHostedHandler hostedHandler;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    AptSnapshotHandler snapshotHandler;
    @Inject
    AptSigningHandler signingHandler;
    @Inject
    LastDownloadedHandler lastDownloadedHandler;
    @Inject
    HandlerContributor handlerContributor;

    @Inject
    public OrientAptHostedRecipe(@Named(value="hosted") @Named(value="hosted") Type type, @Named(value="apt") @Named(value="apt") Format format) {
        super(type, format);
    }

    public void apply(Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.storageFacet.get());
        repository.attach((Facet)this.aptFacet.get());
        repository.attach((Facet)this.aptRestoreFacet.get());
        repository.attach((Facet)this.aptHostedFacet.get());
        repository.attach((Facet)this.aptSigningFacet.get());
        repository.attach((Facet)this.snapshotFacet.get());
        repository.attach((Facet)this.attributesFacet.get());
        repository.attach((Facet)this.componentMaintenance.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.aptHostedMetadataFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        builder.route(new Route.Builder().matcher((Matcher)new AlwaysMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.highAvailabilitySupportHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.unitOfWorkHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.snapshotHandler).handler((Handler)this.signingHandler).handler((Handler)this.hostedHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }
}

