/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class OrientAptHostedHandler
extends ComponentSupport
implements Handler {
    public Response handle(Context context) throws Exception {
        String method;
        String path = this.assetPath(context);
        switch (method = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return this.doGet(context, path);
            }
            case "POST": {
                return this.doPost(context, path, method);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "POST"});
    }

    private Response doPost(Context context, String path, String method) throws IOException {
        OrientAptHostedFacet hostedFacet = (OrientAptHostedFacet)context.getRepository().facet(OrientAptHostedFacet.class);
        if ("rebuild-indexes".equals(path)) {
            hostedFacet.rebuildMetadata();
            return HttpResponses.ok();
        }
        if ("".equals(path)) {
            hostedFacet.ingestAsset(context.getRequest().getPayload());
            hostedFacet.invalidateMetadata();
            return HttpResponses.created();
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD"});
    }

    private Response doGet(Context context, String path) throws IOException {
        OrientAptFacet aptFacet = (OrientAptFacet)context.getRepository().facet(OrientAptFacet.class);
        if (this.isMetadataRebuildRequired(path, aptFacet)) {
            ((OrientAptHostedFacet)context.getRepository().facet(OrientAptHostedFacet.class)).rebuildMetadata();
        }
        Optional<Content> content = aptFacet.get(path);
        return content.map(HttpResponses::ok).orElseGet(() -> HttpResponses.notFound((String)path));
    }

    private boolean isMetadataRebuildRequired(String path, OrientAptFacet aptFacet) throws IOException {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"dists") && StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"InRelease", "Release", "Release.gpg", "/Packages"})) {
            String inReleasePath = "dists/" + aptFacet.getDistribution() + "/" + "InRelease";
            return !aptFacet.get(inReleasePath).isPresent();
        }
        return false;
    }

    private String assetPath(Context context) {
        return ((AptSnapshotHandler.State)context.getAttributes().require(AptSnapshotHandler.State.class)).assetPath;
    }
}

