/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.metadata.OrientAptHostedMetadataFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientAptHostedFacet
extends FacetSupport {
    private static final String P_INDEX_SECTION = "index_section";
    private static final String P_ARCHITECTURE = "architecture";
    private static final String P_PACKAGE_NAME = "package_name";
    private static final String P_PACKAGE_VERSION = "package_version";

    public Asset ingestAsset(Payload body) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(body, AptFacetHelper.hashAlgorithms);){
            ControlFile control = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob).getControlFile();
            if (control == null) {
                throw new IllegalOperationException("Invalid Debian package supplied");
            }
            return this.ingestAsset(control, tempBlob, body.getSize(), body.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Asset ingestAsset(ControlFile control, TempBlob body, long size, String contentType) throws IOException {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        PackageInfo info = new PackageInfo(control);
        String name = info.getPackageName();
        String version = info.getVersion();
        String architecture = info.getArchitecture();
        String assetPath = AptFacetHelper.buildAssetPath(name, version, architecture);
        Content content = aptFacet.put(assetPath, (Payload)new StreamPayload((InputStreamSupplier)body, size, contentType), info);
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)bucket, (Content)content);
        String indexSection = this.buildIndexSection(control, asset.size(), asset.getChecksums(AptFacetHelper.hashAlgorithms), assetPath);
        asset.formatAttributes().set(P_ARCHITECTURE, (Object)architecture);
        asset.formatAttributes().set(P_PACKAGE_NAME, (Object)name);
        asset.formatAttributes().set(P_PACKAGE_VERSION, (Object)version);
        asset.formatAttributes().set(P_INDEX_SECTION, (Object)indexSection);
        asset.formatAttributes().set("asset_kind", (Object)"DEB");
        tx.saveAsset(asset);
        return asset;
    }

    public void rebuildMetadata() throws IOException {
        this.metadata().rebuildMetadata(Collections.emptyList());
    }

    public void invalidateMetadata() {
        this.metadata().invalidateMetadata();
    }

    private String buildIndexSection(ControlFile cf, long size, Map<HashAlgorithm, HashCode> hashes, String assetPath) {
        ControlFile.Paragraph modified = cf.getParagraphs().get(0).withFields(Arrays.asList(new ControlFile.ControlField("Filename", assetPath), new ControlFile.ControlField("Size", Long.toString(size)), new ControlFile.ControlField("MD5Sum", hashes.get(HashAlgorithm.MD5).toString()), new ControlFile.ControlField("SHA1", hashes.get(HashAlgorithm.SHA1).toString()), new ControlFile.ControlField("SHA256", hashes.get(HashAlgorithm.SHA256).toString())));
        return modified.toString();
    }

    private OrientAptHostedMetadataFacet metadata() {
        return (OrientAptHostedMetadataFacet)this.facet(OrientAptHostedMetadataFacet.class);
    }

    public static class AssetChange {
        public final AssetAction action;
        public final Asset asset;

        public AssetChange(AssetAction action, Asset asset) {
            this.action = action;
            this.asset = asset;
        }
    }
}

