/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import com.orientechnologies.common.concur.ONeedRetryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientAptHostedComponentMaintenanceFacet
extends DefaultComponentMaintenanceImpl {
    @Transactional(retryOn={ONeedRetryException.class})
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlobs) {
        Component component;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        String assetKind = (String)asset.formatAttributes().get("asset_kind", String.class);
        Set result = super.deleteAssetTx(assetId, deleteBlobs);
        if ("DEB".equals(assetKind)) {
            ((OrientAptHostedFacet)this.getRepository().facet(OrientAptHostedFacet.class)).invalidateMetadata();
        }
        if (asset.componentId() != null && !tx.browseAssets(component = tx.findComponentInBucket(asset.componentId(), bucket)).iterator().hasNext()) {
            this.log.debug("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlobs);
        }
        return result;
    }

    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return new DefaultComponentMaintenanceImpl.DeletionResult(null, Collections.emptySet());
        }
        Iterable assets = tx.browseAssets(component);
        ArrayList<OrientAptHostedFacet.AssetChange> changes = new ArrayList<OrientAptHostedFacet.AssetChange>();
        for (Asset asset : assets) {
            changes.add(new OrientAptHostedFacet.AssetChange(AssetAction.REMOVED, asset));
        }
        this.log.debug("Deleting component: {}", (Object)component.toStringExternal());
        DefaultComponentMaintenanceImpl.DeletionResult result = new DefaultComponentMaintenanceImpl.DeletionResult(component, tx.deleteComponent(component, deleteBlobs));
        ((OrientAptHostedFacet)this.getRepository().facet(OrientAptHostedFacet.class)).invalidateMetadata();
        return result;
    }
}

