/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="apt")
@Singleton
public class OrientAptComponentDirector
extends ComponentSupport
implements ComponentDirector {
    private final BucketStore bucketStore;
    private final RepositoryManager repositoryManager;

    @Inject
    public OrientAptComponentDirector(BucketStore bucketStore, RepositoryManager repositoryManager) {
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return this.repositoryFor(component).isPresent();
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        UnitOfWork.begin((Supplier)((StorageFacet)destination.facet(StorageFacet.class)).txSupplier());
        try {
            ((OrientAptHostedFacet)destination.facet(OrientAptHostedFacet.class)).invalidateMetadata();
        }
        finally {
            UnitOfWork.end();
        }
    }

    private Optional<Repository> repositoryFor(Component component) {
        return Optional.of(component).map(MetadataNode::bucketId).map(arg_0 -> ((BucketStore)this.bucketStore).getById(arg_0)).map(Bucket::getRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0));
    }
}

