/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="apt")
public class OrientAptBrowseNodeGenerator
implements BrowseNodeGenerator {
    private static final String PACKAGES_PATH = "packages";
    private static final String METADATA_PATH = "metadata";

    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            BrowsePaths.appendPath(paths, (String)asset.name());
            return paths;
        }
        ArrayList<String> pathParts = new ArrayList<String>();
        String name = asset.name();
        if (name.endsWith(".deb") || name.endsWith(".udeb")) {
            pathParts.add(PACKAGES_PATH);
        } else if (!name.startsWith("snapshots")) {
            pathParts.add(METADATA_PATH);
        }
        pathParts.addAll(Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)name));
        return BrowsePaths.fromPaths(pathParts, (boolean)false);
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<String> pathParts = new ArrayList<String>();
        pathParts.add(PACKAGES_PATH);
        pathParts.add(component.name().substring(0, 1).toLowerCase());
        pathParts.add(component.name());
        pathParts.add(component.version());
        pathParts.add(component.group());
        pathParts.add(component.name());
        return BrowsePaths.fromPaths(pathParts, (boolean)true);
    }
}

