/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient;

import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.AptUploadHandlerSupport;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="apt")
public class OrientAptUploadHandler
extends AptUploadHandlerSupport {
    @Inject
    public OrientAptUploadHandler(@Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(variableResolverAdapter, contentPermissionChecker, uploadDefinitionExtensions);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        OrientAptHostedFacet hostedFacet = (OrientAptHostedFacet)repository.facet(OrientAptHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)((AssetUpload)upload.getAssetUploads().get(0)).getPayload(), AptFacetHelper.hashAlgorithms);){
            UploadResponse uploadResponse;
            ControlFile controlFile = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob).getControlFile();
            String assetPath = AptFacetHelper.buildAssetPath(controlFile);
            this.doValidation(repository, assetPath);
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            try {
                Asset asset = hostedFacet.ingestAsset((Payload)((AssetUpload)upload.getAssetUploads().get(0)).getPayload());
                hostedFacet.invalidateMetadata();
                uploadResponse = new UploadResponse(asset);
            }
            catch (Throwable throwable2) {
                UnitOfWork.end();
                throw throwable2;
            }
            UnitOfWork.end();
            return uploadResponse;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

