/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFileParser;
import org.sonatype.nexus.repository.apt.internal.snapshot.AllSnapshotComponentSelector;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.FilteredSnapshotComponentSelector;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class AptSnapshotHandler
extends ComponentSupport
implements Handler {
    private static final Pattern SNAPSHOT_PATH_PATTERN = Pattern.compile("/snapshots/([^/]+)/?(.*)");

    public Response handle(Context context) throws Exception {
        String path = context.getRequest().getPath();
        Matcher matcher = SNAPSHOT_PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            context.getAttributes().set(State.class, (Object)new State(path.substring(1)));
            return context.proceed();
        }
        String id = matcher.group(1);
        path = matcher.group(2);
        if (path.length() == 0) {
            return this.handleSnapshotAdminRequest(context, id);
        }
        return this.handleSnapshotFetchRequest(context, id, path);
    }

    private Response handleSnapshotAdminRequest(Context context, String id) throws Exception {
        String method = context.getRequest().getAction();
        Repository repository = context.getRepository();
        AptSnapshotFacet snapshotFacet = (AptSnapshotFacet)repository.facet(AptSnapshotFacet.class);
        switch (method) {
            case "MKCOL": {
                return this.doMkcol(id, snapshotFacet);
            }
            case "PUT": {
                return this.doPut(context, id, snapshotFacet);
            }
            case "DELETE": {
                return this.doDelete(id, snapshotFacet);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"DELETE", "MKCOL", "PUT"});
    }

    private Response doMkcol(String id, AptSnapshotFacet snapshotFacet) throws IOException {
        snapshotFacet.createSnapshot(id, new AllSnapshotComponentSelector());
        return HttpResponses.created();
    }

    private Response doPut(Context context, String id, AptSnapshotFacet snapshotFacet) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = context.getRequest().getPayload().openInputStream();){
            ControlFile settings = new ControlFileParser().parseControlFile(is);
            snapshotFacet.createSnapshot(id, new FilteredSnapshotComponentSelector(settings));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return HttpResponses.created();
    }

    private Response doDelete(String id, AptSnapshotFacet snapshotFacet) throws IOException {
        snapshotFacet.deleteSnapshot(id);
        return HttpResponses.noContent();
    }

    private Response handleSnapshotFetchRequest(Context context, String id, String path) throws Exception {
        Repository repository = context.getRepository();
        AptSnapshotFacet snapshotFacet = (AptSnapshotFacet)repository.facet(AptSnapshotFacet.class);
        if (snapshotFacet.isSnapshotableFile(path)) {
            Content content = snapshotFacet.getSnapshotFile(id, path);
            return content == null ? HttpResponses.notFound() : HttpResponses.ok((Payload)content);
        }
        context.getAttributes().set(State.class, (Object)new State(path));
        return context.proceed();
    }

    public static final class State {
        public final String assetPath;

        public State(String assetPath) {
            this.assetPath = assetPath;
        }
    }
}

