/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.snapshot;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;

public class AptFilterInputStream
extends FilterInputStream {
    private boolean done = false;
    private final ArmoredInputStream armoredIn;

    public AptFilterInputStream(ArmoredInputStream armoredIn) {
        super((InputStream)armoredIn);
        this.armoredIn = armoredIn;
    }

    @Override
    public int read() throws IOException {
        if (this.done) {
            return -1;
        }
        int c = this.armoredIn.read();
        if (c < 0 || !this.armoredIn.isClearText()) {
            this.done = true;
            return -1;
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c == -1) {
                return i == 0 ? -1 : i;
            }
            b[off + i] = (byte)c;
            ++i;
        }
        return len;
    }
}

