/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.hosted;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.bouncycastle.util.io.TeeOutputStream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public class CompressingTempFileStore
extends ComponentSupport
implements AutoCloseable {
    private final Map<String, FileHolder> holdersByKey = new HashMap<String, FileHolder>();

    public Writer openOutput(String key) {
        try {
            if (this.holdersByKey.containsKey(key)) {
                throw new IllegalStateException("Output already opened");
            }
            FileHolder holder = new FileHolder();
            this.holdersByKey.put(key, holder);
            return new OutputStreamWriter((OutputStream)new TeeOutputStream((OutputStream)new TeeOutputStream((OutputStream)new GZIPOutputStream(Files.newOutputStream(holder.gzTempFile, new OpenOption[0])), (OutputStream)new BZip2CompressorOutputStream(Files.newOutputStream(holder.bzTempFile, new OpenOption[0]))), Files.newOutputStream(holder.plainTempFile, new OpenOption[0])), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Map<String, FileMetadata> getFiles() {
        return Maps.transformValues(this.holdersByKey, holder -> new FileMetadata((FileHolder)holder));
    }

    @Override
    public void close() {
        LinkedList<Path> notDeletedFiles = new LinkedList<Path>();
        for (FileHolder holder : this.holdersByKey.values()) {
            this.deleteFile(holder.bzTempFile, notDeletedFiles);
            this.deleteFile(holder.gzTempFile, notDeletedFiles);
        }
        if (!notDeletedFiles.isEmpty()) {
            this.log.warn("Files were not successfully deleted: " + notDeletedFiles);
        }
    }

    private void deleteFile(Path path, List<Path> paths) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            paths.add(path);
        }
    }

    private static class FileHolder {
        final CountingOutputStream plainStream;
        final Path plainTempFile = Files.createTempFile("", "", new FileAttribute[0]);
        final CountingOutputStream gzStream;
        final Path gzTempFile;
        final CountingOutputStream bzStream;
        final Path bzTempFile;

        public FileHolder() throws IOException {
            this.plainStream = new CountingOutputStream(Files.newOutputStream(this.plainTempFile, new OpenOption[0]));
            this.gzTempFile = Files.createTempFile("", "", new FileAttribute[0]);
            this.gzStream = new CountingOutputStream(Files.newOutputStream(this.gzTempFile, new OpenOption[0]));
            this.bzTempFile = Files.createTempFile("", "", new FileAttribute[0]);
            this.bzStream = new CountingOutputStream(Files.newOutputStream(this.bzTempFile, new OpenOption[0]));
        }
    }

    public static class FileMetadata {
        private final FileHolder holder;

        private FileMetadata(FileHolder holder) {
            this.holder = holder;
        }

        public long bzSize() {
            return this.holder.bzStream.getByteCount();
        }

        public InputStreamSupplier bzSupplier() {
            return () -> Files.newInputStream(this.holder.bzTempFile, new OpenOption[0]);
        }

        public long gzSize() {
            return this.holder.gzStream.getByteCount();
        }

        public InputStreamSupplier gzSupplier() {
            return () -> Files.newInputStream(this.holder.gzTempFile, new OpenOption[0]);
        }

        public long plainSize() {
            return this.holder.plainStream.getByteCount();
        }

        public InputStreamSupplier plainSupplier() {
            return () -> Files.newInputStream(this.holder.plainTempFile, new OpenOption[0]);
        }
    }
}

