/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.gpg;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class AptSigningHandler
extends ComponentSupport
implements Handler {
    public Response handle(Context context) throws Exception {
        String path = this.assetPath(context);
        String method = context.getRequest().getAction();
        AptSigningFacet facet = (AptSigningFacet)context.getRepository().facet(AptSigningFacet.class);
        if ("repository-key.gpg".equals(path) && "GET".equals(method)) {
            return HttpResponses.ok((Payload)facet.getPublicKey());
        }
        return context.proceed();
    }

    private String assetPath(Context context) {
        return ((AptSnapshotHandler.State)context.getAttributes().require(AptSnapshotHandler.State.class)).assetPath;
    }
}

