/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.debian;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebianVersion
implements Comparable<DebianVersion> {
    private static final Pattern VERSION_PART = Pattern.compile("(\\D*)(\\d*)");
    private int epoch = 0;
    private String debianRevision = "";
    private String upstreamVersion;

    public DebianVersion(String version) {
        Preconditions.checkNotNull((Object)version);
        int colonIndex = version.indexOf(58);
        int hyphenIndex = version.lastIndexOf(45);
        this.epoch = this.parseEpoch(version, colonIndex);
        this.debianRevision = this.parseDebianRevision(version, hyphenIndex);
        this.upstreamVersion = this.parseUpstreamVersion(version, colonIndex, hyphenIndex);
    }

    public int getEpoch() {
        return this.epoch;
    }

    public String getDebianRevision() {
        return this.debianRevision;
    }

    public String getUpstreamVersion() {
        return this.upstreamVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.epoch > 0) {
            sb.append(this.epoch);
            sb.append(":");
        }
        sb.append(this.upstreamVersion);
        if (this.debianRevision.length() > 0) {
            sb.append("-");
            sb.append(this.debianRevision);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(DebianVersion o) {
        if (this.epoch < o.epoch) {
            return -1;
        }
        if (this.epoch > o.epoch) {
            return 1;
        }
        int uv = DebianVersion.compareDebianVersion(this.upstreamVersion, o.upstreamVersion);
        if (uv != 0) {
            return uv;
        }
        return DebianVersion.compareDebianVersion(this.debianRevision, o.debianRevision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebianVersion version = (DebianVersion)o;
        return this.epoch == version.epoch && Objects.equals(this.debianRevision, version.debianRevision) && Objects.equals(this.upstreamVersion, version.upstreamVersion);
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.debianRevision, this.upstreamVersion);
    }

    private int parseEpoch(String version, int colonIndex) {
        return colonIndex > 0 ? Integer.parseInt(version.substring(0, colonIndex)) : 0;
    }

    private String parseUpstreamVersion(String version, int colonIndex, int hyphenIndex) {
        int beginIndex = colonIndex > 0 ? colonIndex + 1 : 0;
        int endIndex = hyphenIndex > 0 ? hyphenIndex : version.length();
        return version.substring(beginIndex, endIndex);
    }

    private String parseDebianRevision(String version, int hyphenIndex) {
        return hyphenIndex > 0 ? version.substring(hyphenIndex + 1) : "";
    }

    private static int compareDebianVersion(String a, String b) {
        Matcher ma = VERSION_PART.matcher(a);
        Matcher mb = VERSION_PART.matcher(b);
        String na = "";
        String nna = "";
        String nb = "";
        String nnb = "";
        do {
            if (ma.find()) {
                nna = ma.group(1);
                na = ma.group(2);
            } else {
                nna = "";
                na = "";
            }
            if (mb.find()) {
                nnb = mb.group(1);
                nb = mb.group(2);
            } else {
                nnb = "";
                nb = "";
            }
            int nn = DebianVersion.compareNonNumeric(nna, nnb);
            if (nn != 0) {
                return nn;
            }
            int n = DebianVersion.compareNumeric(na, nb);
            if (n == 0) continue;
            return n;
        } while (na.length() > 0 || nna.length() > 0 || nb.length() > 0 || nnb.length() > 0);
        return 0;
    }

    private static int compareNonNumeric(String a, String b) {
        int len = Math.max(a.length(), b.length());
        int i = 0;
        while (i < len) {
            int ac = i >= a.length() ? -1 : a.codePointAt(i);
            int bc = i >= b.length() ? -1 : b.codePointAt(i);
            if (DebianVersion.priorityClass(ac) < DebianVersion.priorityClass(bc)) {
                return -1;
            }
            if (DebianVersion.priorityClass(ac) > DebianVersion.priorityClass(bc)) {
                return 1;
            }
            if (ac < bc) {
                return -1;
            }
            if (ac > bc) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private static int compareNumeric(String a, String b) {
        if (a.isEmpty() && !b.isEmpty()) {
            return -1;
        }
        if (b.isEmpty() && !a.isEmpty()) {
            return 1;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return 0;
        }
        return Long.compare(Long.parseLong(a), Long.parseLong(b));
    }

    private static int priorityClass(int c) {
        return c == 126 ? -2 : (c == -1 ? -1 : (Character.isLetter(c) ? 0 : 1));
    }
}

