/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.debian;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;

public class ControlFileParser {
    private static final Pattern FIELD_PATTERN = Pattern.compile("((?:[\\!-9]|[\\;-\\~])+):(.*)");
    private final List<ControlFile.Paragraph> paragraphs = new ArrayList<ControlFile.Paragraph>();
    private final List<ControlFile.ControlField> fields = new ArrayList<ControlFile.ControlField>();
    private final StringBuilder valueBuilder = new StringBuilder();
    private final StringBuilder sigBuilder = new StringBuilder();
    private boolean inField = false;
    private String fieldName;

    public ControlFile parseControlFile(InputStream stream) throws IOException {
        String line;
        this.paragraphs.clear();
        this.fields.clear();
        this.valueBuilder.setLength(0);
        this.sigBuilder.setLength(0);
        this.inField = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                this.finishField();
                this.finishParagraph();
                continue;
            }
            int first = line.codePointAt(0);
            if (first == 35) continue;
            if (Character.isWhitespace(first)) {
                this.valueBuilder.append('\n');
                this.valueBuilder.append(line);
                continue;
            }
            this.finishField();
            this.beginField(line);
        }
        this.finishField();
        this.finishParagraph();
        return new ControlFile(this.paragraphs);
    }

    private void finishParagraph() {
        if (this.fields.isEmpty()) {
            return;
        }
        this.paragraphs.add(new ControlFile.Paragraph(this.fields));
        this.fields.clear();
    }

    private void finishField() {
        if (!this.inField) {
            return;
        }
        this.fields.add(new ControlFile.ControlField(this.fieldName, this.valueBuilder.toString()));
        this.valueBuilder.setLength(0);
        this.inField = false;
    }

    private void beginField(String line) throws IOException {
        Matcher m = FIELD_PATTERN.matcher(line);
        if (!m.matches()) {
            throw new IOException("Invalid line: " + line);
        }
        this.fieldName = m.group(1);
        this.valueBuilder.append(m.group(2).trim());
        this.inField = true;
    }
}

