/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFileParser;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.internal.org.apache.commons.compress.archivers.ar.ArArchiveInputStream;

public class AptPackageParser {
    private AptPackageParser() {
        throw new IllegalAccessError("Utility class");
    }

    public static PackageInfo parsePackageInfo(InputStreamSupplier supplier) throws IOException {
        ControlFile controlFile = AptPackageParser.parsePackageInternal(supplier);
        if (controlFile == null) {
            throw new IOException("Invalid debian package: no control file");
        }
        return new PackageInfo(controlFile);
    }

    private static ControlFile parsePackageInternal(InputStreamSupplier supplier) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ArArchiveInputStream is = new ArArchiveInputStream(supplier.get());){
            ArchiveEntry debEntry;
            ControlFile control = null;
            block22: while ((debEntry = is.getNextEntry()) != null) {
                CloseShieldInputStream controlStream;
                switch (debEntry.getName()) {
                    case "control.tar": {
                        controlStream = new CloseShieldInputStream((InputStream)((Object)is));
                        break;
                    }
                    case "control.tar.gz": {
                        controlStream = new GzipCompressorInputStream((InputStream)new CloseShieldInputStream((InputStream)((Object)is)));
                        break;
                    }
                    case "control.tar.xz": {
                        controlStream = new XZCompressorInputStream((InputStream)new CloseShieldInputStream((InputStream)((Object)is)));
                        break;
                    }
                    case "control.tar.zst": {
                        controlStream = new ZstdCompressorInputStream((InputStream)new CloseShieldInputStream((InputStream)((Object)is)));
                        break;
                    }
                    default: {
                        continue block22;
                    }
                }
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (TarArchiveInputStream controlTarStream = new TarArchiveInputStream((InputStream)controlStream);){
                    TarArchiveEntry tarEntry;
                    while ((tarEntry = controlTarStream.getNextEntry()) != null) {
                        if (!"control".equals(tarEntry.getName()) && !"./control".equals(tarEntry.getName())) continue;
                        control = new ControlFileParser().parseControlFile((InputStream)controlTarStream);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            return control;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

