/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotItem;

public class AptFacetHelper {
    public static final List<HashAlgorithm> hashAlgorithms = ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);
    private static final String RELEASE_PATH = "dists/%s/%s";
    private static final String PACKAGE_PATH = "dists/%s/%s/binary-%s/%s";
    private static final String ASSET_PATH = "pool/%s/%s/%s";
    private static final String MISSED_VALUE_MESSAGE = "Control file doesn't contain '%s' field.";
    private static final String PACKAGE = "Package";
    private static final String VERSION = "Version";
    private static final String ARCHITECTURE = "Architecture";

    public static List<SnapshotItem.ContentSpecifier> getReleaseIndexSpecifiers(boolean isFlat, String dist) {
        if (isFlat) {
            return ImmutableList.of((Object)new SnapshotItem.ContentSpecifier("Release", SnapshotItem.Role.RELEASE_INDEX), (Object)new SnapshotItem.ContentSpecifier("Release.gpg", SnapshotItem.Role.RELEASE_SIG), (Object)new SnapshotItem.ContentSpecifier("InRelease", SnapshotItem.Role.RELEASE_INLINE_INDEX));
        }
        return ImmutableList.of((Object)new SnapshotItem.ContentSpecifier(String.format(RELEASE_PATH, dist, "Release"), SnapshotItem.Role.RELEASE_INDEX), (Object)new SnapshotItem.ContentSpecifier(String.format(RELEASE_PATH, dist, "Release.gpg"), SnapshotItem.Role.RELEASE_SIG), (Object)new SnapshotItem.ContentSpecifier(String.format(RELEASE_PATH, dist, "InRelease"), SnapshotItem.Role.RELEASE_INLINE_INDEX));
    }

    public static List<SnapshotItem.ContentSpecifier> getReleasePackageIndexes(boolean isFlat, String dist, String component, String arch) {
        if (isFlat) {
            return ImmutableList.of((Object)new SnapshotItem.ContentSpecifier("Packages", SnapshotItem.Role.PACKAGE_INDEX_RAW), (Object)new SnapshotItem.ContentSpecifier("Packages.gz", SnapshotItem.Role.PACKAGE_INDEX_GZ), (Object)new SnapshotItem.ContentSpecifier("Packages.bz2", SnapshotItem.Role.PACKAGE_INDEX_BZ2), (Object)new SnapshotItem.ContentSpecifier("Packages.xz", SnapshotItem.Role.PACKAGE_INDEX_XZ));
        }
        return ImmutableList.of((Object)new SnapshotItem.ContentSpecifier(String.format(PACKAGE_PATH, dist, component, arch, "Packages"), SnapshotItem.Role.PACKAGE_INDEX_RAW), (Object)new SnapshotItem.ContentSpecifier(String.format(PACKAGE_PATH, dist, component, arch, "Packages.gz"), SnapshotItem.Role.PACKAGE_INDEX_GZ), (Object)new SnapshotItem.ContentSpecifier(String.format(PACKAGE_PATH, dist, component, arch, "Packages.bz2"), SnapshotItem.Role.PACKAGE_INDEX_BZ2), (Object)new SnapshotItem.ContentSpecifier(String.format(PACKAGE_PATH, dist, component, arch, "Packages.xz"), SnapshotItem.Role.PACKAGE_INDEX_XZ));
    }

    public static String buildAssetName(String packageName, String version, String architecture) {
        return String.valueOf(packageName) + "_" + version + "_" + architecture + ".deb";
    }

    public static String buildAssetPath(String packageName, String version, String architecture) {
        return String.format(ASSET_PATH, packageName.substring(0, 1), packageName, AptFacetHelper.buildAssetName(packageName, version, architecture));
    }

    public static String buildAssetPath(ControlFile controlFile) {
        String name = AptFacetHelper.getValueFromControlFile(controlFile, PACKAGE);
        String version = AptFacetHelper.getValueFromControlFile(controlFile, VERSION);
        String architecture = AptFacetHelper.getValueFromControlFile(controlFile, ARCHITECTURE);
        return AptFacetHelper.buildAssetPath(name, version, architecture);
    }

    private static String getValueFromControlFile(ControlFile controlFile, String fieldName) {
        return controlFile.getField(fieldName).map(f -> f.value).orElseThrow(() -> new IllegalStateException(String.format(MISSED_VALUE_MESSAGE, fieldName)));
    }

    public static String normalizeAssetPath(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private AptFacetHelper() {
    }
}

