/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.task;

import java.io.IOException;
import java.util.Collections;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.data.AptKeyValueFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.metadata.AptHostedMetadataFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class RebuildAptMetadataTask
extends RepositoryTaskSupport
implements Cancelable {
    protected void execute(Repository repository) {
        this.log.debug("Populating metadata in repository {} started", (Object)repository.getName());
        boolean isFullRebuild = this.getConfiguration().getBoolean("rebuildAptMetadataFullRebuild", false);
        this.executeRebuild(repository, isFullRebuild);
    }

    private void executeRebuild(Repository repository, boolean isFullRebuild) {
        if (isFullRebuild) {
            this.data(repository).removeAllPackageMetadata();
        }
        Iterable<FluentAsset> assets = this.content(repository).getAptPackageAssets();
        for (FluentAsset asset : assets) {
            CancelableHelper.checkCancellation();
            this.metadata(repository).addPackageMetadata(asset);
        }
        this.metadata(repository).removeInReleaseIndex();
        try {
            this.metadata(repository).rebuildMetadata(Collections.emptyList());
        }
        catch (IOException e) {
            this.log.error("Error index rebuilding", (Throwable)(this.log.isDebugEnabled() ? e : null));
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.getFormat().getValue().equals("apt") && repository.getType().getValue().equals("hosted");
    }

    public String getMessage() {
        return "Rebuilding Apt metadata in " + this.getRepositoryField();
    }

    private AptContentFacet content(Repository repository) {
        return (AptContentFacet)repository.facet(AptContentFacet.class);
    }

    private AptKeyValueFacet data(Repository repository) {
        return (AptKeyValueFacet)repository.facet(AptKeyValueFacet.class);
    }

    private AptHostedMetadataFacet metadata(Repository repository) {
        return (AptHostedMetadataFacet)repository.facet(AptHostedMetadataFacet.class);
    }
}

