/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.snapshot;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFileParser;
import org.sonatype.nexus.repository.apt.internal.debian.Release;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptFilterInputStream;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotComponentSelector;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotItem;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public abstract class AptSnapshotFacetSupport
extends FacetSupport
implements AptSnapshotFacet {
    @Override
    public boolean isSnapshotableFile(String path) {
        return !path.endsWith(".deb") && !path.endsWith(".DEB");
    }

    @Override
    public void createSnapshot(String id, SnapshotComponentSelector selector) throws IOException {
        Iterable<SnapshotItem> snapshots = this.collectSnapshotItems(selector);
        this.createSnapshot(id, snapshots);
    }

    protected void createSnapshot(String id, Iterable<SnapshotItem> snapshots) throws IOException {
        Preconditions.checkNotNull((Object)id);
        AptContentFacet contentFacet = (AptContentFacet)this.facet(AptContentFacet.class);
        for (SnapshotItem item : snapshots) {
            String assetPath = this.createAssetPath(id, item.specifier.path);
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                InputStream is = item.content.openInputStream();
                try {
                    try (TempBlob tempBlob = contentFacet.getTempBlob(is, item.specifier.role.getMimeType());){
                        contentFacet.findOrCreateMetadataAsset(tempBlob, assetPath);
                    }
                    if (is == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    @Override
    @Nullable
    public Content getSnapshotFile(String id, String path) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)path);
        String assetPath = this.createAssetPath(id, path);
        AptContentFacet contentFacet = (AptContentFacet)this.facet(AptContentFacet.class);
        return contentFacet.get(assetPath).orElse(null);
    }

    @Override
    public void deleteSnapshot(String id) {
        Preconditions.checkNotNull((Object)id);
        AptContentFacet contentFacet = (AptContentFacet)this.facet(AptContentFacet.class);
        String path = this.createAssetPath(id, "");
        contentFacet.deleteAssetsByPrefix(path);
    }

    protected Iterable<SnapshotItem> collectSnapshotItems(SnapshotComponentSelector selector) throws IOException {
        Release release;
        AptContentFacet aptFacet = (AptContentFacet)this.getRepository().facet(AptContentFacet.class);
        List<SnapshotItem> releaseIndexItems = this.fetchSnapshotItems(AptFacetHelper.getReleaseIndexSpecifiers(aptFacet.isFlat(), aptFacet.getDistribution()));
        EnumMap<SnapshotItem.Role, SnapshotItem> itemsByRole = new EnumMap<SnapshotItem.Role, SnapshotItem>(releaseIndexItems.stream().collect(Collectors.toMap(item -> item.specifier.role, item -> item)));
        InputStream releaseStream = null;
        SnapshotItem snapshotItem = (SnapshotItem)itemsByRole.get((Object)SnapshotItem.Role.RELEASE_INDEX);
        if (snapshotItem != null) {
            releaseStream = snapshotItem.content.openInputStream();
        } else {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream is = ((SnapshotItem)itemsByRole.get((Object)((Object)SnapshotItem.Role.RELEASE_INLINE_INDEX))).content.openInputStream();){
                if (is != null) {
                    ArmoredInputStream aIs = new ArmoredInputStream(is);
                    releaseStream = new AptFilterInputStream(aIs);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (releaseStream == null) {
            throw new IOException("Invalid upstream repository: no release index present");
        }
        try {
            ControlFile index = new ControlFileParser().parseControlFile(releaseStream);
            release = new Release(index);
        }
        finally {
            releaseStream.close();
        }
        ArrayList<SnapshotItem> result = new ArrayList<SnapshotItem>(releaseIndexItems);
        if (aptFacet.isFlat()) {
            result.addAll(this.fetchSnapshotItems(AptFacetHelper.getReleasePackageIndexes(aptFacet.isFlat(), aptFacet.getDistribution(), null, null)));
        } else {
            List<String> archs = selector.getArchitectures(release);
            List<String> comps = selector.getComponents(release);
            for (String arch : archs) {
                for (String comp : comps) {
                    result.addAll(this.fetchSnapshotItems(AptFacetHelper.getReleasePackageIndexes(aptFacet.isFlat(), aptFacet.getDistribution(), comp, arch)));
                }
            }
        }
        return result;
    }

    private String createAssetPath(String id, String path) {
        return "/snapshots/" + id + "/" + path;
    }

    protected abstract List<SnapshotItem> fetchSnapshotItems(List<SnapshotItem.ContentSpecifier> var1) throws IOException;
}

