/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.proxy;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.proxy.AptProxyFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.proxy.AptProxySnapshotFacet;
import org.sonatype.nexus.repository.apt.internal.AptSecurityFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheHandler;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyHandler;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.AlwaysMatcher;

@AvailabilityVersion(from="1.0")
@Named(value="apt-proxy")
@Singleton
public class AptProxyRecipe
extends RecipeSupport {
    public static final String NAME = "apt-proxy";
    @Inject
    Provider<AptSecurityFacet> securityFacet;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<HttpClientFacet> httpClientFacet;
    @Inject
    Provider<NegativeCacheFacet> negativeCacheFacet;
    @Inject
    Provider<AptProxyFacet> proxyFacet;
    @Inject
    Provider<AptProxySnapshotFacet> proxySnapshotFacet;
    @Inject
    Provider<PurgeUnusedFacet> purgeUnusedFacet;
    @Inject
    Provider<LastAssetMaintenanceFacet> lastAssetMaintenanceFacet;
    @Inject
    Provider<AptContentFacet> aptContentFacet;
    @Inject
    Provider<SearchFacet> searchFacet;
    @Inject
    Provider<BrowseFacet> browseFacet;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    NegativeCacheHandler negativeCacheHandler;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    ProxyHandler proxyHandler;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    AptSnapshotHandler snapshotHandler;
    @Inject
    LastDownloadedHandler lastDownloadedHandler;
    @Inject
    RoutingRuleHandler routingRuleHandler;
    @Inject
    HandlerContributor handlerContributor;

    @Inject
    public AptProxyRecipe(@Named(value="proxy") @Named(value="proxy") Type type, @Named(value="apt") @Named(value="apt") Format format) {
        super(type, format);
    }

    public void apply(Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.negativeCacheFacet.get());
        repository.attach((Facet)this.proxyFacet.get());
        repository.attach((Facet)this.proxySnapshotFacet.get());
        repository.attach((Facet)this.aptContentFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.lastAssetMaintenanceFacet.get());
        repository.attach((Facet)this.purgeUnusedFacet.get());
        repository.attach((Facet)this.searchFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        builder.route(new Route.Builder().matcher((Matcher)new AlwaysMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingRuleHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.negativeCacheHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.snapshotHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.proxyHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }
}

