/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.proxy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.HttpClientUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.debian.Utils;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotItem;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyServiceException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.HttpEntityPayload;

@Named
@Facet.Exposed
public class AptProxyFacet
extends ContentProxyFacetSupport {
    public List<SnapshotItem> getSnapshotItems(List<SnapshotItem.ContentSpecifier> specs) throws IOException {
        return this.fetchLatest(specs);
    }

    protected Content getCachedContent(Context context) {
        return ((AptContentFacet)this.facet(AptContentFacet.class)).get(this.assetPath(context)).orElse(null);
    }

    protected Content store(Context context, Content content) throws IOException {
        if (this.assetPath(context).endsWith("Release")) {
            this.cacheControllerHolder.getMetadataCacheController().invalidateCache();
        }
        return ((AptContentFacet)this.facet(AptContentFacet.class)).put(this.assetPath(context), (Payload)content).markAsCached((Payload)content).download();
    }

    protected String getUrl(Context context) {
        return this.assetPath(context);
    }

    protected CacheController getCacheController(Context context) {
        if (Utils.isDebPackageContentType(this.assetPath(context))) {
            return this.cacheControllerHolder.getContentCacheController();
        }
        return this.cacheControllerHolder.getMetadataCacheController();
    }

    private String assetPath(Context context) {
        return ((AptSnapshotHandler.State)context.getAttributes().require(AptSnapshotHandler.State.class)).assetPath;
    }

    private List<SnapshotItem> fetchLatest(List<SnapshotItem.ContentSpecifier> specs) throws IOException {
        ArrayList<SnapshotItem> list = new ArrayList<SnapshotItem>();
        for (SnapshotItem.ContentSpecifier spec : specs) {
            Optional<SnapshotItem> item = this.fetchLatest(spec);
            if (!item.isPresent()) continue;
            list.add(item.get());
        }
        return list;
    }

    private Optional<SnapshotItem> fetchLatest(SnapshotItem.ContentSpecifier spec) throws IOException {
        URI fetchUri;
        ProxyFacet proxyFacet = (ProxyFacet)this.facet(ProxyFacet.class);
        HttpClientFacet httpClientFacet = (HttpClientFacet)this.facet(HttpClientFacet.class);
        HttpClient httpClient = httpClientFacet.getHttpClient();
        CacheController cacheController = this.cacheControllerHolder.getMetadataCacheController();
        CacheInfo cacheInfo = cacheController.current();
        Content oldVersion = ((AptContentFacet)this.facet(AptContentFacet.class)).get(spec.path).orElse(null);
        HttpGet getRequest = this.buildFetchRequest(oldVersion, fetchUri = proxyFacet.getRemoteUrl().resolve(spec.path));
        HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            Content fetchedContent = new Content((Payload)new HttpEntityPayload(response, entity));
            AttributesMap contentAttrs = fetchedContent.getAttributes();
            contentAttrs.set("last_modified", (Object)this.getDateHeader(response, "Last-Modified"));
            contentAttrs.set("etag", (Object)this.getQuotedStringHeader(response, "ETag"));
            contentAttrs.set(CacheInfo.class, (Object)cacheInfo);
            Content storedContent = ((AptContentFacet)this.facet(AptContentFacet.class)).put(spec.path, (Payload)fetchedContent).download();
            return Optional.of(new SnapshotItem(spec, storedContent));
        }
        try {
            if (status.getStatusCode() == 304) {
                Preconditions.checkState((oldVersion != null ? 1 : 0) != 0, (String)"Received 304 without conditional GET (bad server?) from %s", (Object)fetchUri);
                this.doIndicateVerified(oldVersion, cacheInfo, spec.path);
                Optional<SnapshotItem> optional = Optional.of(new SnapshotItem(spec, oldVersion));
                return optional;
            }
            this.throwProxyExceptionForStatus(response);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        return Optional.empty();
    }

    private HttpGet buildFetchRequest(Content oldVersion, URI fetchUri) {
        HttpGet getRequest = new HttpGet(fetchUri);
        if (oldVersion != null) {
            String etag;
            DateTime lastModified = (DateTime)oldVersion.getAttributes().get("last_modified", DateTime.class);
            if (lastModified != null) {
                getRequest.addHeader("If-Modified-Since", DateUtils.formatDate((Date)lastModified.toDate()));
            }
            if ((etag = (String)oldVersion.getAttributes().get("etag", String.class)) != null) {
                getRequest.addHeader("If-None-Match", "\"" + etag + "\"");
            }
        }
        return getRequest;
    }

    private DateTime getDateHeader(HttpResponse response, String name) {
        Header h = response.getLastHeader(name);
        if (h != null) {
            try {
                return new DateTime(DateUtils.parseDate((String)h.getValue()).getTime());
            }
            catch (Exception ex) {
                this.log.warn("Invalid date '{}', will skip. {}", (Object)h, (Object)(this.log.isDebugEnabled() ? ex : null));
            }
        }
        return null;
    }

    private String getQuotedStringHeader(HttpResponse response, String name) {
        String value;
        Header h = response.getLastHeader(name);
        if (h != null && !Strings.isNullOrEmpty((String)(value = h.getValue()))) {
            if (value.startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }

    protected void doIndicateVerified(Content content, CacheInfo cacheInfo, String assetPath) {
        AptContentFacet contentFacet = (AptContentFacet)this.facet(AptContentFacet.class);
        Asset asset = (Asset)content.getAttributes().get(Asset.class);
        if (asset != null) {
            contentFacet.assets().with(asset).markAsCached(cacheInfo);
            return;
        }
        ((AptContentFacet)this.facet(AptContentFacet.class)).getAsset(assetPath).ifPresent(a -> {
            FluentAsset fluentAsset = contentFacet.assets().with((Asset)a).markAsCached(cacheInfo);
        });
    }

    private void throwProxyExceptionForStatus(HttpResponse httpResponse) {
        StatusLine status = httpResponse.getStatusLine();
        if (401 == status.getStatusCode() || 402 == status.getStatusCode() || 407 == status.getStatusCode() || 500 <= status.getStatusCode()) {
            throw new ProxyServiceException(httpResponse);
        }
    }
}

