/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.data.AptKeyValueFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.internal.hosted.CompressingTempFileStore;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named(value="apt")
@Facet.Exposed
public class AptHostedMetadataFacet
extends FacetSupport {
    private final ObjectMapper mapper;
    private final Clock clock;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;

    @Inject
    public AptHostedMetadataFacet(ObjectMapper mapper, Clock clock, Cooperation2Factory cooperationFactory, @Named(value="${nexus.apt.metadata.cooperation.enabled:-true}") @Named(value="${nexus.apt.metadata.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.apt.metadata.cooperation.majorTimeout:-0s}") @Named(value="${nexus.apt.metadata.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.apt.metadata.cooperation.minorTimeout:-30s}") @Named(value="${nexus.apt.metadata.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.apt.metadata.cooperation.threadsPerKey:-100}") @Named(value="${nexus.apt.metadata.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":repomd");
    }

    public void addPackageMetadata(FluentAsset asset) {
        Preconditions.checkNotNull((Object)asset);
        this.log.debug("Storing metadata for repository: {} asset: {}", (Object)this.getRepository().getName(), (Object)asset.path());
        AptHostedMetadataFacet.componentId((Asset)asset).ifPresent(componentId -> this.data().addPackageMetadata(componentId, InternalIds.internalAssetId((Asset)asset), this.serialize(asset)));
    }

    public void removePackageMetadata(FluentAsset asset) {
        Preconditions.checkNotNull((Object)asset);
        this.log.debug("Removing metadata for repository: {} asset: {}", (Object)this.getRepository().getName(), (Object)asset.path());
        AptHostedMetadataFacet.componentId((Asset)asset).ifPresent(componentId -> this.data().removePackageMetadata(componentId, InternalIds.internalAssetId((Asset)asset)));
    }

    public void removeInReleaseIndex() {
        this.content().deleteAssetsByPrefix(AptFacetHelper.normalizeAssetPath(this.releaseIndexName("InRelease")));
    }

    public Optional<Content> rebuildMetadata(List<AssetChange> changeList) throws IOException {
        return Optional.ofNullable((Content)this.cooperation.on(() -> this.doRebuildMetadata(changeList)).cooperate(changeList.toString(), new String[0]));
    }

    private void removeMetadataPerArchitecture() {
        this.log.debug("Removing metadata per architecture: {}", (Object)this.getRepository().getName());
        this.content().deleteAssetsByPrefix(AptFacetHelper.normalizeAssetPath(this.mainBinaryPrefix()));
    }

    private Content doRebuildMetadata(List<AssetChange> changeList) throws IOException {
        String releaseFile;
        this.log.debug("Starting rebuilding metadata at {}", (Object)this.getRepository().getName());
        OffsetDateTime rebuildStart = this.clock.clusterTime();
        AptContentFacet aptFacet = this.content();
        AptSigningFacet signingFacet = this.signing();
        this.removeMetadataPerArchitecture();
        StringBuilder sha256Builder = new StringBuilder();
        StringBuilder md5Builder = new StringBuilder();
        Throwable throwable = null;
        Object var9_9 = null;
        try (CompressingTempFileStore store = this.buildPackageIndexes(changeList);){
            for (Map.Entry<String, CompressingTempFileStore.FileMetadata> entry : store.getFiles().entrySet()) {
                FluentAsset metadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ""), (Payload)new StreamPayload(entry.getValue().plainSupplier(), entry.getValue().plainSize(), "text/plain"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, metadataAsset, this.packageRelativeIndexName(entry.getKey(), ""));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, metadataAsset, this.packageRelativeIndexName(entry.getKey(), ""));
                FluentAsset gzMetadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ".gz"), (Payload)new StreamPayload(entry.getValue().gzSupplier(), entry.getValue().bzSize(), "application/gzip"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, gzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, gzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                FluentAsset bzMetadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ".bz2"), (Payload)new StreamPayload(entry.getValue().bzSupplier(), entry.getValue().bzSize(), "application/bzip2"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, bzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, bzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
            }
            releaseFile = this.buildReleaseFile(aptFacet.getDistribution(), store.getFiles().keySet(), md5Builder.toString(), sha256Builder.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FluentAsset releaseFileAsset = aptFacet.put(this.releaseIndexName("Release"), (Payload)new BytesPayload(releaseFile.getBytes(StandardCharsets.UTF_8), "text/plain"));
        aptFacet.put(this.releaseIndexName("InRelease"), (Payload)new BytesPayload(signingFacet.signInline(releaseFile), "text/plain"));
        aptFacet.put(this.releaseIndexName("Release.gpg"), (Payload)new BytesPayload(signingFacet.signExternal(releaseFile), "application/pgp-signature"));
        if (this.log.isDebugEnabled()) {
            long finishTime = System.currentTimeMillis();
            this.log.debug("Completed metadata rebuild in {}", (Object)(finishTime - rebuildStart.toInstant().toEpochMilli()));
        }
        return releaseFileAsset.download();
    }

    /*
     * Unable to fully structure code
     */
    private CompressingTempFileStore buildPackageIndexes(List<AssetChange> changes) throws IOException {
        result = new CompressingTempFileStore();
        streams = new HashMap<String, Writer>();
        ok = false;
        try {
            architectures = changes.stream().map((Function<AssetChange, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Ljava/lang/String;)((AptHostedMetadataFacet)this)).collect(Collectors.toSet());
            packagesInfo = this.data().browsePackagesMetadata().map((Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, deserialize(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)((AptHostedMetadataFacet)this)).collect(Collectors.toList());
            packagesInfo.stream().map((Function<Map, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(java.util.Map ), (Ljava/util/Map;)Ljava/lang/String;)()).collect(Collectors.toCollection((Supplier<Set>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$6(java.util.Set ), ()Ljava/util/Set;)(architectures)));
            assetsPerArch = new HashMap<String, List<T>>();
            for (String architecture : architectures) {
                assets = packagesInfo.stream().filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$7(java.lang.String java.util.Map ), (Ljava/util/Map;)Z)((String)architecture)).collect(Collectors.toList());
                assetsPerArch.put(architecture, assets);
            }
            for (List assets : assetsPerArch.values()) {
                removeAssetChange = changes.stream().filter((Predicate<AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$8(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Z)()).filter((Predicate<AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$9(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Z)()).findAny();
                if (assets.isEmpty() && removeAssetChange.isPresent()) {
                    this.createEmptyMetadataFile(result, streams, removeAssetChange.get());
                    continue;
                }
                this.createMetadataFileWithData(changes, result, streams, assets);
            }
            ok = true;
        }
        finally {
            ** for (writer : streams.values())
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Closeable)writer, null);
            continue;
        }
lbl28:
        // 1 sources

        if (!ok) {
            result.close();
        }
        return result;
    }

    private void createMetadataFileWithData(List<AssetChange> changes, CompressingTempFileStore result, Map<String, Writer> streams, List<Map<String, Object>> assets) throws IOException {
        Set excludeNames = changes.stream().map(c -> c.getAsset().path()).collect(Collectors.toSet());
        for (Map<String, Object> asset : assets) {
            String name = asset.get("package_name").toString();
            String arch = asset.get("architecture").toString();
            Writer outWriter = streams.computeIfAbsent(arch, result::openOutput);
            if (excludeNames.contains(name)) continue;
            String indexSection = asset.get("index_section").toString();
            outWriter.write(indexSection);
            outWriter.write("\n\n");
        }
    }

    private String buildReleaseFile(String distribution, Collection<String> architectures, String md5, String sha256) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"));
        ControlFile.Paragraph p = new ControlFile.Paragraph(Arrays.asList(new ControlFile.ControlField("Suite", distribution), new ControlFile.ControlField("Codename", distribution), new ControlFile.ControlField("Components", "main"), new ControlFile.ControlField("Date", date), new ControlFile.ControlField("Architectures", String.join((CharSequence)" ", architectures)), new ControlFile.ControlField("SHA256", sha256), new ControlFile.ControlField("MD5Sum", md5)));
        return p.toString();
    }

    private String mainBinaryPrefix() {
        String dist = this.content().getDistribution();
        return "dists/" + dist + "/main/binary-";
    }

    private String releaseIndexName(String name) {
        String dist = this.content().getDistribution();
        return "dists/" + dist + "/" + name;
    }

    private String packageIndexName(String arch, String ext) {
        String dist = this.content().getDistribution();
        return "dists/" + dist + "/main/binary-" + arch + "/Packages" + ext;
    }

    private String packageRelativeIndexName(String arch, String ext) {
        return "main/binary-" + arch + "/Packages" + ext;
    }

    private void addSignatureItem(StringBuilder builder, HashAlgorithm algo, FluentAsset asset, String filename) {
        AssetBlob assetBlob = (AssetBlob)asset.blob().orElseThrow(() -> new IllegalStateException("Cannot generate signature for metadata. Blob couldn't be found for asset: " + filename));
        builder.append("\n ");
        builder.append((String)assetBlob.checksums().get(algo.name()));
        builder.append(" ");
        builder.append(assetBlob.blobSize());
        builder.append(" ");
        builder.append(filename);
    }

    private String getArchitecture(FluentAsset asset) {
        return (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("architecture");
    }

    private void createEmptyMetadataFile(CompressingTempFileStore result, Map<String, Writer> streams, AssetChange removeAssetChange) {
        String arch = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)removeAssetChange.getAsset()).get("architecture");
        streams.computeIfAbsent(arch, result::openOutput);
    }

    private AptContentFacet content() {
        return (AptContentFacet)this.facet(AptContentFacet.class);
    }

    private AptKeyValueFacet data() {
        return (AptKeyValueFacet)this.facet(AptKeyValueFacet.class);
    }

    private AptSigningFacet signing() {
        return (AptSigningFacet)this.facet(AptSigningFacet.class);
    }

    private static OptionalInt componentId(Asset asset) {
        return InternalIds.internalComponentId((Asset)asset);
    }

    private String serialize(FluentAsset asset) {
        try {
            return this.mapper.writeValueAsString((Object)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Map<String, Object> deserialize(String value) {
        try {
            return (Map)this.mapper.readValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private /* synthetic */ String lambda$3(AssetChange change) {
        return this.getArchitecture(change.getAsset());
    }

    private static /* synthetic */ String lambda$5(Map x) {
        return x.get("architecture").toString();
    }

    private static /* synthetic */ Set lambda$6(Set set) {
        return set;
    }

    private static /* synthetic */ boolean lambda$7(String string, Map x) {
        return x.get("architecture").toString().equals(string);
    }

    private static /* synthetic */ boolean lambda$8(AssetChange change) {
        return change.getAsset().kind().equals("DEB");
    }

    private static /* synthetic */ boolean lambda$9(AssetChange change) {
        return change.getAction() == AssetAction.REMOVED;
    }
}

