/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.data.AptKeyValueFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedHandler;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedSnapshotFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptLastAssetMaintenanceFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.metadata.AptHostedMetadataFacet;
import org.sonatype.nexus.repository.apt.internal.AptSecurityFacet;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.AlwaysMatcher;

@AvailabilityVersion(from="1.0")
@Named(value="apt-hosted")
@Singleton
public class AptHostedRecipe
extends RecipeSupport {
    public static final String NAME = "apt-hosted";
    @Inject
    Provider<AptSecurityFacet> securityFacet;
    @Inject
    Provider<AptSigningFacet> aptSigningFacet;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<AptContentFacet> aptContentFacet;
    @Inject
    Provider<AptHostedFacet> aptHostedFacet;
    @Inject
    Provider<BrowseFacet> browseFacet;
    @Inject
    Provider<AptLastAssetMaintenanceFacet> maintenanceFacet;
    @Inject
    Provider<AptHostedSnapshotFacet> hostedSnapshotFacet;
    @Inject
    Provider<AptKeyValueFacet> aptKeyValueFacet;
    @Inject
    Provider<AptHostedMetadataFacet> aptHostedMetadataFacet;
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    HandlerContributor handlerContributor;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    LastDownloadedHandler lastDownloadedHandler;
    @Inject
    AptSnapshotHandler snapshotHandler;
    @Inject
    AptHostedHandler hostedHandler;
    @Inject
    Provider<SearchFacet> searchFacet;

    @Inject
    public AptHostedRecipe(@Named(value="hosted") @Named(value="hosted") Type type, @Named(value="apt") @Named(value="apt") Format format) {
        super(type, format);
    }

    public void apply(Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.aptSigningFacet.get());
        repository.attach((Facet)this.aptContentFacet.get());
        repository.attach((Facet)this.aptHostedFacet.get());
        repository.attach((Facet)this.maintenanceFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.hostedSnapshotFacet.get());
        repository.attach((Facet)this.aptKeyValueFacet.get());
        repository.attach((Facet)this.aptHostedMetadataFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        builder.route(new Route.Builder().matcher((Matcher)new AlwaysMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.snapshotHandler).handler((Handler)this.hostedHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }
}

